/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.serialization;

import it.link.pdd.tools.migrazione_govway.utils.checksum.ChecksumAdler;
import it.link.pdd.tools.migrazione_govway.utils.checksum.ChecksumCRC;
import it.link.pdd.tools.migrazione_govway.utils.serialization.Filter;
import it.link.pdd.tools.migrazione_govway.utils.serialization.FilterChecksumTypes;
import it.link.pdd.tools.migrazione_govway.utils.serialization.FilteredObject;
import it.link.pdd.tools.migrazione_govway.utils.serialization.IDBuilder;
import it.link.pdd.tools.migrazione_govway.utils.serialization.ISerializer;

public class PropertyFilter
implements net.sf.json.util.PropertyFilter {
    private IDBuilder idBuilder = null;
    private Filter filter = null;
    private ISerializer serializer = null;

    public PropertyFilter(Filter filter, IDBuilder idBuilder, ISerializer serializer) {
        this.idBuilder = idBuilder;
        this.filter = filter;
        this.serializer = serializer;
    }

    public PropertyFilter(Filter filter, ISerializer serializer) {
        this.filter = filter;
        this.serializer = serializer;
    }

    public boolean apply(Object source, String name, Object value) {
        if (value != null) {
            for (int i = 0; i < this.filter.sizeFiltersByValue(); ++i) {
                Class<?> classFilter = this.filter.getFilterByValue(i);
                if (!value.getClass().getName().equals(classFilter.getName())) continue;
                this.applicaFiltro(source, name, value, classFilter);
                return true;
            }
        }
        String nomeField = source.getClass().getName() + "." + name;
        for (int i = 0; i < this.filter.sizeFiltersByName(); ++i) {
            String filterName = this.filter.getFilterByName(i);
            if (!nomeField.equals(filterName) || value == null) continue;
            this.applicaFiltro(source, name, value, value.getClass());
            return true;
        }
        return value == null;
    }

    private void applicaFiltro(Object source, String name, Object value, Class<?> classFilter) {
        try {
            FilteredObject oggettoFiltrato = new FilteredObject();
            String id = null;
            try {
                id = this.idBuilder.toID(source, name);
            }
            catch (Exception e) {
                return;
            }
            if (this.filter.existsFilteredObject(id)) {
                return;
            }
            if (this.idBuilder != null) {
                oggettoFiltrato.setId(id);
            }
            long checksum = -1L;
            byte[] byteOggetto = null;
            byteOggetto = value instanceof byte[] ? (byte[])value : this.serializer.getObject(value).getBytes();
            checksum = FilterChecksumTypes.ADLER.toString().equals(this.filter.getFilterChecksumType().toString()) ? ChecksumAdler.checksumAdler32(byteOggetto) : ChecksumCRC.checksumCRC32(byteOggetto);
            oggettoFiltrato.setChecksum(checksum);
            oggettoFiltrato.setClassType(classFilter);
            this.filter.addFilteredObject(oggettoFiltrato);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }
}

