/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.semaphore;

import it.link.pdd.tools.migrazione_govway.utils.semaphore.ISemaphoreEventGenerator;
import it.link.pdd.tools.migrazione_govway.utils.semaphore.SemaphoreEvent;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;

public class SemaphoreLogEventGenerator
implements ISemaphoreEventGenerator {
    private static final String format = "yyyy-MM-dd_HH:mm:ss.SSS";
    private Logger log;

    public SemaphoreLogEventGenerator(Logger log) {
        this.log = log;
    }

    @Override
    public void emitEvent(Connection con, SemaphoreEvent event) {
        SimpleDateFormat dateformat = new SimpleDateFormat(format);
        String msg = "[" + event.getSeverity() + "] [" + event.getOperationType() + "] Date[" + dateformat.format(event.getDate()) + "] IdNode[" + event.getIdNode() + "] [Lock:" + event.isLock() + "]: " + event.getDetails();
        switch (event.getSeverity()) {
            case DEBUG: {
                this.log.debug(msg);
                break;
            }
            case INFO: {
                this.log.info(msg);
                break;
            }
            case WARN: {
                this.log.warn(msg);
                break;
            }
            case ERROR: {
                this.log.error(msg);
            }
        }
    }
}

