/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.semaphore;

import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.date.DateManager;
import it.link.pdd.tools.migrazione_govway.utils.id.serial.InfoStatistics;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.JDBCParameterUtilities;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.JDBCUtilities;
import it.link.pdd.tools.migrazione_govway.utils.semaphore.SemaphoreConfiguration;
import it.link.pdd.tools.migrazione_govway.utils.semaphore.SemaphoreEvent;
import it.link.pdd.tools.migrazione_govway.utils.semaphore.SemaphoreEventSeverity;
import it.link.pdd.tools.migrazione_govway.utils.semaphore.SemaphoreMapping;
import it.link.pdd.tools.migrazione_govway.utils.semaphore.SemaphoreOperationType;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLObjectFactory;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Random;
import org.slf4j.Logger;

public class SemaphoreEngine {
    private static final String format = "yyyy-MM-dd_HH:mm:ss.SSS";
    private SemaphoreMapping mapping;
    private SemaphoreConfiguration config;
    private TipiDatabase databaseType;
    private JDBCParameterUtilities jdbcParameterUtils;
    private Logger log;

    protected static SemaphoreEngine getSemaphore(SemaphoreMapping mapping, SemaphoreConfiguration config, TipiDatabase databaseType, Logger log) throws UtilsException {
        return new SemaphoreEngine(mapping, config, databaseType, log);
    }

    public SemaphoreEngine(SemaphoreMapping mapping, SemaphoreConfiguration config, TipiDatabase databaseType, Logger log) throws UtilsException {
        this.mapping = mapping;
        this.config = config;
        this.databaseType = databaseType;
        this.log = log;
        if (this.mapping.getTable() == null) {
            throw new UtilsException("Table name not defined in SemaphoreMapping");
        }
        if (this.mapping.getIdNode() == null) {
            throw new UtilsException("IdNode column name not defined in SemaphoreMapping");
        }
        if (this.mapping.getLockDate() == null) {
            throw new UtilsException("Lock Date column name not defined in SemaphoreMapping");
        }
        if (this.mapping.getUpdateDate() == null) {
            throw new UtilsException("Update Date column name not defined in SemaphoreMapping");
        }
        if (this.databaseType == null) {
            throw new UtilsException("Database Type not defined");
        }
        try {
            this.jdbcParameterUtils = new JDBCParameterUtilities(this.databaseType);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    protected boolean lock(Connection conDB, String details, InfoStatistics infoStatistics, SemaphoreOperationType operationType) throws UtilsException {
        String msgError;
        boolean operazioneConclusaConSuccesso = false;
        long attesaAttivaJDBC = this.config.getSerializableTimeWaitMs();
        int checkIntervalloJDBC = this.config.getSerializableNextIntervalTimeMs();
        boolean processOK = false;
        long scadenzaWhile = DateManager.getTimeMillis() + attesaAttivaJDBC;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        int iteration = 0;
        ArrayList<String> messageException = new ArrayList<String>();
        String table = this.mapping.getTable();
        String columnIdNode = this.mapping.getIdNode();
        String columnLockDate = this.mapping.getLockDate();
        String columnUpdateDate = this.mapping.getUpdateDate();
        String columnDetails = this.mapping.getDetails();
        boolean rowNotExistsAndSerializableLevelNotFound = false;
        while (!processOK && !rowNotExistsAndSerializableLevelNotFound && DateManager.getTimeMillis() < scadenzaWhile) {
            ++iteration;
            operazioneConclusaConSuccesso = false;
            PreparedStatement pstmt = null;
            Statement pstmtInsert = null;
            ResultSet rs = null;
            try {
                ISQLQueryObject sqlGet = SQLObjectFactory.createSQLQueryObject(this.databaseType);
                sqlGet.addSelectField(columnIdNode);
                sqlGet.addSelectField(columnLockDate);
                sqlGet.addSelectField(columnUpdateDate);
                sqlGet.addFromTable(table);
                sqlGet.setANDLogicOperator(true);
                if (this.mapping.sizeUniqueConditionValues() > 0) {
                    for (int i = 0; i < this.mapping.sizeUniqueConditionValues(); ++i) {
                        Object o = this.mapping.getUniqueConditionValue(i);
                        if (o != null) {
                            sqlGet.addWhereCondition(this.mapping.getUniqueConditionColumnName(i) + "=?");
                            continue;
                        }
                        sqlGet.addWhereIsNullCondition(this.mapping.getUniqueConditionColumnName(i));
                    }
                }
                sqlGet.setSelectForUpdate(true);
                pstmt = conDB.prepareStatement(sqlGet.createSQLQuery());
                int index = 1;
                if (this.mapping.sizeUniqueConditionValues() > 0) {
                    for (int i = 0; i < this.mapping.sizeUniqueConditionValues(); ++i) {
                        Object o = this.mapping.getUniqueConditionValue(i);
                        if (o == null) continue;
                        this.jdbcParameterUtils.setParameter(pstmt, index++, this.mapping.getUniqueConditionValue(i), this.mapping.getUniqueConditionType(i));
                    }
                }
                if ((rs = pstmt.executeQuery()) == null) {
                    pstmt.close();
                    this.log.error("Creazione serial non riuscita: ResultSet is null?");
                    throw new UtilsException("Creazione serial non riuscita: ResultSet is null?");
                }
                boolean exist = rs.next();
                String idNode = null;
                Timestamp lockDate = null;
                Timestamp updateDate = null;
                if (exist) {
                    idNode = rs.getString(columnIdNode);
                    lockDate = rs.getTimestamp(columnLockDate);
                    updateDate = rs.getTimestamp(columnUpdateDate);
                }
                rs.close();
                pstmt.close();
                if (!exist && !JDBCUtilities.isTransactionIsolationSerializable(conDB.getTransactionIsolation(), this.databaseType)) {
                    rowNotExistsAndSerializableLevelNotFound = true;
                    continue;
                }
                Timestamp now = DateManager.getTimestamp();
                SimpleDateFormat dateformat = new SimpleDateFormat(format);
                StringBuffer statoLock = new StringBuffer("Lock per tabella [" + table + "]");
                if (this.mapping.sizeUniqueConditionValues() > 0) {
                    for (int i = 0; i < this.mapping.sizeUniqueConditionValues(); ++i) {
                        statoLock.append(" [" + this.mapping.getUniqueConditionColumnName(i) + "=" + this.mapping.getUniqueConditionValue(i) + "]");
                    }
                }
                statoLock.append("\n");
                if (exist && idNode != null) {
                    statoLock.append("OldIdNode[" + idNode + "] OldcreateTime[" + dateformat.format(lockDate) + "] OldupdateTime[" + dateformat.format(updateDate) + "]");
                    statoLock.append("\n");
                }
                statoLock.append("IdNode[" + this.config.getIdNode() + "] ");
                statoLock.append("Now[" + dateformat.format(now) + "]");
                if (details != null) {
                    statoLock.append(" Details[" + details + "]");
                }
                SemaphoreEvent semaphoreEvent = new SemaphoreEvent();
                semaphoreEvent.setDate(now);
                semaphoreEvent.setOperationType(operationType);
                semaphoreEvent.setIdNode(this.config.getIdNode());
                boolean emitSemaphoreEvent = false;
                if (SemaphoreOperationType.NEW.equals((Object)operationType)) {
                    if (!exist) {
                        int i;
                        ISQLQueryObject sqlInsert = SQLObjectFactory.createSQLQueryObject(this.databaseType);
                        sqlInsert.addInsertTable(table);
                        sqlInsert.addInsertField(columnIdNode, "?");
                        sqlInsert.addInsertField(columnLockDate, "?");
                        sqlInsert.addInsertField(columnUpdateDate, "?");
                        sqlInsert.addInsertField(columnDetails, "?");
                        if (this.mapping.sizeUniqueConditionValues() > 0) {
                            for (i = 0; i < this.mapping.sizeUniqueConditionValues(); ++i) {
                                sqlInsert.addInsertField(this.mapping.getUniqueConditionColumnName(i), "?");
                            }
                        }
                        pstmtInsert = conDB.prepareStatement(sqlInsert.createSQLInsert());
                        index = 1;
                        pstmtInsert.setString(index++, this.config.getIdNode());
                        pstmtInsert.setTimestamp(index++, now);
                        pstmtInsert.setTimestamp(index++, now);
                        this.jdbcParameterUtils.setParameter((PreparedStatement)pstmtInsert, index++, details, String.class);
                        if (this.mapping.sizeUniqueConditionValues() > 0) {
                            for (i = 0; i < this.mapping.sizeUniqueConditionValues(); ++i) {
                                this.jdbcParameterUtils.setParameter((PreparedStatement)pstmtInsert, index++, this.mapping.getUniqueConditionValue(i), this.mapping.getUniqueConditionType(i));
                            }
                        }
                        pstmtInsert.execute();
                        pstmtInsert.close();
                        operazioneConclusaConSuccesso = true;
                        if (this.config.isEmitEvent()) {
                            semaphoreEvent.setDetails(statoLock.toString());
                            semaphoreEvent.setSeverity(SemaphoreEventSeverity.INFO);
                            semaphoreEvent.setLock(operazioneConclusaConSuccesso);
                            emitSemaphoreEvent = true;
                        }
                    } else {
                        String errore = null;
                        if (idNode == null) {
                            operazioneConclusaConSuccesso = true;
                        } else {
                            long diff;
                            if (this.config.getMaxIdleTime() > 0L && (diff = now.getTime() - updateDate.getTime()) > this.config.getMaxIdleTime()) {
                                errore = "Idle Time (" + this.config.getMaxIdleTime() + "ms) exceeded (actual: " + diff + "ms). Lock obtained for idNode '" + this.config.getIdNode() + "'";
                                operazioneConclusaConSuccesso = true;
                            }
                            if (errore == null && this.config.getMaxLife() > 0L && (diff = now.getTime() - lockDate.getTime()) > this.config.getMaxLife()) {
                                errore = "Max Life Time (" + this.config.getMaxLife() + "ms) exceeded (actual: " + diff + "ms). Lock obtained for idNode '" + this.config.getIdNode() + "'";
                                operazioneConclusaConSuccesso = true;
                            }
                            if (errore != null) {
                                String dettaglioErrore = statoLock.toString() + "\n" + errore;
                                this.log.warn(dettaglioErrore);
                            }
                        }
                        if (operazioneConclusaConSuccesso) {
                            Object o;
                            int i;
                            ISQLQueryObject sqlUpdate = SQLObjectFactory.createSQLQueryObject(this.databaseType);
                            sqlUpdate.addUpdateTable(table);
                            sqlUpdate.addUpdateField(columnIdNode, "?");
                            sqlUpdate.addUpdateField(columnLockDate, "?");
                            sqlUpdate.addUpdateField(columnUpdateDate, "?");
                            sqlUpdate.addUpdateField(columnDetails, "?");
                            sqlUpdate.setANDLogicOperator(true);
                            if (this.mapping.sizeUniqueConditionValues() > 0) {
                                for (i = 0; i < this.mapping.sizeUniqueConditionValues(); ++i) {
                                    o = this.mapping.getUniqueConditionValue(i);
                                    if (o != null) {
                                        sqlUpdate.addWhereCondition(this.mapping.getUniqueConditionColumnName(i) + "=?");
                                        continue;
                                    }
                                    sqlUpdate.addWhereIsNullCondition(this.mapping.getUniqueConditionColumnName(i));
                                }
                            }
                            pstmtInsert = conDB.prepareStatement(sqlUpdate.createSQLUpdate());
                            index = 1;
                            pstmtInsert.setString(index++, this.config.getIdNode());
                            pstmtInsert.setTimestamp(index++, now);
                            pstmtInsert.setTimestamp(index++, now);
                            this.jdbcParameterUtils.setParameter((PreparedStatement)pstmtInsert, index++, details, String.class);
                            if (this.mapping.sizeUniqueConditionValues() > 0) {
                                for (i = 0; i < this.mapping.sizeUniqueConditionValues(); ++i) {
                                    o = this.mapping.getUniqueConditionValue(i);
                                    if (o == null) continue;
                                    this.jdbcParameterUtils.setParameter((PreparedStatement)pstmtInsert, index++, this.mapping.getUniqueConditionValue(i), this.mapping.getUniqueConditionType(i));
                                }
                            }
                            pstmtInsert.executeUpdate();
                            pstmtInsert.close();
                            if (this.config.isEmitEvent()) {
                                if (errore != null) {
                                    semaphoreEvent.setDetails(errore + "\n" + statoLock.toString());
                                } else {
                                    semaphoreEvent.setDetails(statoLock.toString());
                                }
                                semaphoreEvent.setSeverity(SemaphoreEventSeverity.INFO);
                                semaphoreEvent.setLock(operazioneConclusaConSuccesso);
                                emitSemaphoreEvent = true;
                            }
                        }
                    }
                } else if (SemaphoreOperationType.UPDATE.equals((Object)operationType) || SemaphoreOperationType.RELEASE.equals((Object)operationType)) {
                    if (idNode != null && idNode.equals(this.config.getIdNode())) {
                        ISQLQueryObject sqlUpdate = SQLObjectFactory.createSQLQueryObject(this.databaseType);
                        sqlUpdate.addUpdateTable(table);
                        if (SemaphoreOperationType.UPDATE.equals((Object)operationType)) {
                            sqlUpdate.addUpdateField(columnUpdateDate, "?");
                            sqlUpdate.addUpdateField(columnDetails, "?");
                        } else {
                            sqlUpdate.addUpdateField(columnIdNode, "?");
                            sqlUpdate.addUpdateField(columnLockDate, "?");
                            sqlUpdate.addUpdateField(columnUpdateDate, "?");
                            sqlUpdate.addUpdateField(columnDetails, "?");
                        }
                        sqlUpdate.setANDLogicOperator(true);
                        if (this.mapping.sizeUniqueConditionValues() > 0) {
                            for (int i = 0; i < this.mapping.sizeUniqueConditionValues(); ++i) {
                                Object o = this.mapping.getUniqueConditionValue(i);
                                if (o != null) {
                                    sqlUpdate.addWhereCondition(this.mapping.getUniqueConditionColumnName(i) + "=?");
                                    continue;
                                }
                                sqlUpdate.addWhereIsNullCondition(this.mapping.getUniqueConditionColumnName(i));
                            }
                        }
                        pstmtInsert = conDB.prepareStatement(sqlUpdate.createSQLUpdate());
                        index = 1;
                        if (SemaphoreOperationType.UPDATE.equals((Object)operationType)) {
                            pstmtInsert.setTimestamp(index++, now);
                            this.jdbcParameterUtils.setParameter((PreparedStatement)pstmtInsert, index++, details, String.class);
                        } else {
                            this.jdbcParameterUtils.setParameter((PreparedStatement)pstmtInsert, index++, null, String.class);
                            this.jdbcParameterUtils.setParameter((PreparedStatement)pstmtInsert, index++, null, Timestamp.class);
                            this.jdbcParameterUtils.setParameter((PreparedStatement)pstmtInsert, index++, null, Timestamp.class);
                            this.jdbcParameterUtils.setParameter((PreparedStatement)pstmtInsert, index++, null, String.class);
                        }
                        if (this.mapping.sizeUniqueConditionValues() > 0) {
                            for (int i = 0; i < this.mapping.sizeUniqueConditionValues(); ++i) {
                                Object o = this.mapping.getUniqueConditionValue(i);
                                if (o == null) continue;
                                this.jdbcParameterUtils.setParameter((PreparedStatement)pstmtInsert, index++, this.mapping.getUniqueConditionValue(i), this.mapping.getUniqueConditionType(i));
                            }
                        }
                        pstmtInsert.executeUpdate();
                        pstmtInsert.close();
                        operazioneConclusaConSuccesso = true;
                        if (this.config.isEmitEvent()) {
                            semaphoreEvent.setDetails(statoLock.toString());
                            semaphoreEvent.setSeverity(SemaphoreEventSeverity.DEBUG);
                            semaphoreEvent.setLock(operazioneConclusaConSuccesso);
                            emitSemaphoreEvent = true;
                        }
                    } else {
                        Object msgErrore = "IdNode is null, lock without owner";
                        if (idNode != null) {
                            msgErrore = "IdNode owner [" + idNode + "] different";
                        }
                        operazioneConclusaConSuccesso = false;
                        if (this.config.isEmitEvent()) {
                            semaphoreEvent.setDetails(statoLock.toString() + "\n" + (String)msgErrore);
                            semaphoreEvent.setSeverity(SemaphoreEventSeverity.ERROR);
                            semaphoreEvent.setLock(operazioneConclusaConSuccesso);
                            emitSemaphoreEvent = true;
                        }
                    }
                }
                conDB.commit();
                if (emitSemaphoreEvent) {
                    this.config.getEventGenerator().emitEvent(conDB, semaphoreEvent);
                }
                processOK = true;
            }
            catch (Throwable e) {
                ps.append("********* Exception Iteration [" + iteration + "] **********\n");
                String msg = e.getMessage();
                if (msg == null) {
                    msg = "NULL-MESSAGE";
                }
                if (messageException.contains(msg)) {
                    ps.append("Message already occurs: " + msg);
                } else {
                    e.printStackTrace(ps);
                    messageException.add(msg);
                }
                ps.append("\n\n");
                if (infoStatistics != null) {
                    infoStatistics.addErrorSerializableAccess(e);
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmtInsert != null) {
                        pstmtInsert.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    conDB.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (processOK) continue;
            try {
                int intervalloDestro = checkIntervalloJDBC;
                if (this.config.isSerializableNextIntervalTimeMsIncrementMode() && (intervalloDestro += iteration * this.config.getSerializableNextIntervalTimeMsIncrement()) > this.config.getMaxSerializableNextIntervalTimeMs()) {
                    intervalloDestro = this.config.getMaxSerializableNextIntervalTimeMs();
                }
                int sleep = new Random().nextInt(intervalloDestro);
                Utilities.sleep(sleep);
            }
            catch (Exception exception) {}
        }
        try {
            if (ps != null) {
                ps.flush();
            }
        }
        catch (Exception pstmt) {
            // empty catch block
        }
        try {
            if (out != null) {
                out.flush();
            }
        }
        catch (Exception pstmt) {
            // empty catch block
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (Exception pstmt) {
            // empty catch block
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception pstmt) {
            // empty catch block
        }
        if (rowNotExistsAndSerializableLevelNotFound) {
            msgError = "Raw not exists and serializable level is disabled";
            this.log.error(msgError);
            throw new UtilsException(msgError);
        }
        if (!processOK) {
            msgError = "Lock process failed: l'accesso serializable non ha permesso il recupero del lock";
            this.log.error(msgError + ": " + out.toString());
            if (this.config.isEmitEvent()) {
                SemaphoreEvent event = new SemaphoreEvent();
                event.setDate(DateManager.getDate());
                event.setOperationType(operationType);
                event.setDetails(msgError);
                event.setSeverity(SemaphoreEventSeverity.ERROR);
                event.setLock(false);
                this.config.getEventGenerator().emitEvent(conDB, event);
            }
            throw new UtilsException(msgError);
        }
        return operazioneConclusaConSuccesso;
    }
}

