/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.semaphore;

import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.id.serial.InfoStatistics;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.JDBCUtilities;
import it.link.pdd.tools.migrazione_govway.utils.semaphore.SemaphoreConfiguration;
import it.link.pdd.tools.migrazione_govway.utils.semaphore.SemaphoreEngine;
import it.link.pdd.tools.migrazione_govway.utils.semaphore.SemaphoreMapping;
import it.link.pdd.tools.migrazione_govway.utils.semaphore.SemaphoreOperationType;
import java.sql.Connection;
import org.slf4j.Logger;

public class Semaphore {
    private InfoStatistics infoStatistics;
    private SemaphoreEngine engine;
    private TipiDatabase databaseType;
    private Logger log;
    private boolean serializableLevel;

    public Semaphore(InfoStatistics infoStatistics, SemaphoreMapping mapping, SemaphoreConfiguration config, TipiDatabase databaseType, Logger log) throws UtilsException {
        this.infoStatistics = infoStatistics;
        this.engine = new SemaphoreEngine(mapping, config, databaseType, log);
        this.databaseType = databaseType;
        this.log = log;
        this.serializableLevel = config.isSerializableLevel();
    }

    public boolean newLock(Connection con, String details) throws UtilsException {
        return this._engine(con, details, SemaphoreOperationType.NEW);
    }

    public boolean updateLock(Connection con, String details) throws UtilsException {
        return this._engine(con, details, SemaphoreOperationType.UPDATE);
    }

    public boolean releaseLock(Connection con, String details) throws UtilsException {
        return this._engine(con, details, SemaphoreOperationType.RELEASE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _engine(Connection con, String details, SemaphoreOperationType tipo) throws UtilsException {
        if (con == null) {
            throw new UtilsException("Connessione non fornita");
        }
        try {
            if (con.isClosed()) {
                throw new UtilsException("Connessione risulta gi\u00e0 chiusa");
            }
        }
        catch (Exception e) {
            throw new UtilsException("Test Connessione non riuscito: " + e.getMessage(), e);
        }
        boolean originalConnectionAutocommit = false;
        boolean autoCommitModificato = false;
        try {
            originalConnectionAutocommit = con.getAutoCommit();
        }
        catch (Exception e) {
            throw new UtilsException("Verifica AutoCommit Connessione non riuscito: " + e.getMessage(), e);
        }
        if (!originalConnectionAutocommit) {
            throw new UtilsException("Lock [" + tipo + "] failed (Non e' possibile fornire una connessione con autocommit disabilitato poiche' l'utility ha necessita' di effettuare operazioni di commit/rollback)");
        }
        int originalConnectionTransactionIsolation = -1;
        boolean transactionIsolationModificato = false;
        try {
            originalConnectionTransactionIsolation = con.getTransactionIsolation();
        }
        catch (Exception e) {
            throw new UtilsException("Lettura livello di isolamento transazione della Connessione non riuscito: " + e.getMessage(), e);
        }
        try {
            try {
                try {
                    con.rollback();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.serializableLevel) {
                    JDBCUtilities.setTransactionIsolationSerializable(this.databaseType, con);
                    transactionIsolationModificato = true;
                }
                if (originalConnectionAutocommit) {
                    con.setAutoCommit(false);
                    autoCommitModificato = true;
                }
            }
            catch (Exception er) {
                this.log.error("Lock [" + tipo + "] failed (impostazione transazione): " + er.getMessage(), (Throwable)er);
                throw new UtilsException("Lock [" + tipo + "] failed (impostazione transazione): " + er.getMessage(), er);
            }
            boolean bl = this.engine.lock(con, details, this.infoStatistics, tipo);
            return bl;
        }
        finally {
            try {
                if (transactionIsolationModificato) {
                    con.setTransactionIsolation(originalConnectionTransactionIsolation);
                }
                if (autoCommitModificato) {
                    con.setAutoCommit(originalConnectionAutocommit);
                }
            }
            catch (Exception er) {
                this.log.error("Lock [" + tipo + "] failed (ripristino transazione): " + er.getMessage());
                throw new UtilsException("Lock [" + tipo + "] failed (ripristino transazione): " + er.getMessage());
            }
        }
    }
}

