/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.semaphore;

import it.link.pdd.tools.migrazione_govway.utils.semaphore.ISemaphoreEventGenerator;
import it.link.pdd.tools.migrazione_govway.utils.semaphore.SemaphoreEvent;
import it.link.pdd.tools.migrazione_govway.utils.semaphore.SemaphoreOperationType;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

class EventGeneratorLog
implements ISemaphoreEventGenerator {
    private static final String format = "yyyy-MM-dd_HH:mm:ss.SSS";
    private Logger log;
    private List<String> acquisiti = new ArrayList<String>();
    private List<String> aggiornati = new ArrayList<String>();
    private List<String> rilasciati = new ArrayList<String>();
    private List<String> errori = new ArrayList<String>();

    public List<String> getAcquisiti() {
        return this.acquisiti;
    }

    public List<String> getAggiornati() {
        return this.aggiornati;
    }

    public List<String> getRilasciati() {
        return this.rilasciati;
    }

    public List<String> getErrori() {
        return this.errori;
    }

    public EventGeneratorLog(Logger log) {
        this.log = log;
    }

    @Override
    public void emitEvent(Connection con, SemaphoreEvent event) {
        SimpleDateFormat dateformat = new SimpleDateFormat(format);
        this.log.info("[" + event.getSeverity() + "] [" + event.getOperationType() + "] Date[" + dateformat.format(event.getDate()) + "] IdNode[" + event.getIdNode() + "] [Lock:" + event.isLock() + "]: " + event.getDetails() + "\n");
        if (event.isLock()) {
            if (SemaphoreOperationType.NEW.equals((Object)event.getOperationType())) {
                if (this.acquisiti.contains(event.getIdNode())) {
                    this.errori.add("Riscontrato pi\u00f9 di un lock per l'id node: " + event.getIdNode());
                } else {
                    this.acquisiti.add(event.getIdNode());
                }
            } else if (SemaphoreOperationType.UPDATE.equals((Object)event.getOperationType())) {
                this.aggiornati.add(event.getIdNode());
            } else if (SemaphoreOperationType.RELEASE.equals((Object)event.getOperationType())) {
                if (!this.acquisiti.contains(event.getIdNode())) {
                    this.errori.add("Riscontrato un rilascio di lock per un nodo per cui non era stato ottenuto un lock: " + event.getIdNode());
                } else if (this.rilasciati.contains(event.getIdNode())) {
                    this.errori.add("Riscontrato pi\u00f9 di un rilascio di lock per l'id node: " + event.getIdNode());
                } else {
                    this.rilasciati.add(event.getIdNode());
                }
            }
        }
    }
}

