/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.security;

import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlSignature {
    private static final String DEFAULT_SIGNATURE_METHOD = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    private static final String DEFAULT_DIGEST_METHOD = "http://www.w3.org/2001/04/xmlenc#sha256";
    private static final String DEFAULT_CANONICALIZATION_METHOD = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    private KeyStore keystore;
    private PrivateKey privateKey;
    private String alias;
    private String referenceUri;
    private List<Transform> transforms = new ArrayList<Transform>();
    private XMLSignatureFactory xmlSignatureFactory;
    private KeyInfoFactory keyInfoFactory;
    private KeyInfo keyInfo;

    public XmlSignature(KeyStore keystore, String alias, String passwordPrivateKey) throws UtilsException {
        this(keystore, alias, passwordPrivateKey, false);
    }

    public XmlSignature(KeyStore keystore, String alias, String passwordPrivateKey, boolean addBouncyCastleProvider) throws UtilsException {
        this.keystore = keystore;
        this.privateKey = this.keystore.getPrivateKey(alias, passwordPrivateKey);
        this.alias = alias;
        try {
            if (addBouncyCastleProvider) {
                BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
                Security.addProvider((Provider)bouncyCastleProvider);
            }
            this.xmlSignatureFactory = XMLSignatureFactory.getInstance("DOM");
            this.referenceUri = "";
            this.addTransform(this.xmlSignatureFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public String getReferenceUri() {
        return this.referenceUri;
    }

    public void setReferenceUri(String referenceUri) {
        this.referenceUri = referenceUri;
    }

    public List<Transform> getTransforms() {
        return this.transforms;
    }

    public void setTransforms(List<Transform> transforms) {
        this.transforms = transforms;
    }

    public void addTransform(Transform transform) {
        this.transforms.add(transform);
    }

    public KeyInfoFactory getKeyInfoFactory() {
        if (this.keyInfoFactory == null) {
            this.initKeyInfoFactory();
        }
        return this.keyInfoFactory;
    }

    private synchronized void initKeyInfoFactory() {
        if (this.keyInfoFactory == null) {
            this.keyInfoFactory = this.xmlSignatureFactory.getKeyInfoFactory();
        }
    }

    public KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public void setKeyInfo(KeyInfo keyInfo) {
        this.keyInfo = keyInfo;
    }

    public void addRSAKeyInfo() throws UtilsException {
        this.addRSAKeyInfo(this.alias);
    }

    public void addRSAKeyInfo(String alias) throws UtilsException {
        try {
            KeyValue keyValue = this.getKeyInfoFactory().newKeyValue(this.keystore.getCertificate(alias).getPublicKey());
            this.keyInfo = this.getKeyInfoFactory().newKeyInfo(Collections.singletonList(keyValue));
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void addX509KeyInfo() throws UtilsException {
        this.addX509KeyInfo(this.alias);
    }

    public void addX509KeyInfo(String alias) throws UtilsException {
        try {
            ArrayList<Object> x509Content = new ArrayList<Object>();
            Certificate cert = this.keystore.getCertificate(alias);
            if (cert instanceof X509Certificate) {
                x509Content.add(((X509Certificate)cert).getSubjectX500Principal().getName());
            }
            x509Content.add(cert);
            X509Data x509Data = this.getKeyInfoFactory().newX509Data(x509Content);
            this.keyInfo = this.getKeyInfoFactory().newKeyInfo(Collections.singletonList(x509Data));
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void sign(Document element) throws UtilsException {
        this._sign(element.getDocumentElement(), DEFAULT_SIGNATURE_METHOD, DEFAULT_DIGEST_METHOD, DEFAULT_CANONICALIZATION_METHOD);
    }

    public void sign(Element element) throws UtilsException {
        this._sign(element, DEFAULT_SIGNATURE_METHOD, DEFAULT_DIGEST_METHOD, DEFAULT_CANONICALIZATION_METHOD);
    }

    public void sign(Document element, String signatureMethod, String digestMethod, String canonicalizationMethod) throws UtilsException {
        this._sign(element.getDocumentElement(), signatureMethod, digestMethod, canonicalizationMethod);
    }

    public void sign(Element element, String signatureMethod, String digestMethod, String canonicalizationMethod) throws UtilsException {
        this._sign(element, signatureMethod, digestMethod, canonicalizationMethod);
    }

    public void sign(Document element, SignatureMethod signatureMethod, DigestMethod digestMethod, CanonicalizationMethod canonicalizationMethod) throws UtilsException {
        this._sign(element.getDocumentElement(), signatureMethod, digestMethod, canonicalizationMethod);
    }

    public void sign(Element element, SignatureMethod signatureMethod, DigestMethod digestMethod, CanonicalizationMethod canonicalizationMethod) throws UtilsException {
        this._sign(element, signatureMethod, digestMethod, canonicalizationMethod);
    }

    private void _sign(Element element, String signatureMethod, String digestMethod, String canonicalizationMethod) throws UtilsException {
        try {
            this._sign(element, this.xmlSignatureFactory.newSignatureMethod(signatureMethod, null), this.xmlSignatureFactory.newDigestMethod(digestMethod, null), this.xmlSignatureFactory.newCanonicalizationMethod(canonicalizationMethod, (C14NMethodParameterSpec)null));
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private void _sign(Element element, SignatureMethod signatureMethod, DigestMethod digestMethod, CanonicalizationMethod canonicalizationMethod) throws UtilsException {
        try {
            DOMSignContext domSignContext = new DOMSignContext(this.privateKey, (Node)element);
            Reference signedReference = this.xmlSignatureFactory.newReference(this.referenceUri, digestMethod, this.transforms, null, null);
            SignedInfo signedInfo = this.xmlSignatureFactory.newSignedInfo(canonicalizationMethod, signatureMethod, Collections.singletonList(signedReference));
            XMLSignature xmlSignatureEngine = this.xmlSignatureFactory.newXMLSignature(signedInfo, this.keyInfo);
            xmlSignatureEngine.sign(domSignContext);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

