/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.security;

import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.security.AbstractXmlCipher;
import it.link.pdd.tools.migrazione_govway.utils.security.KeyStore;
import java.security.Key;
import java.security.cert.Certificate;
import javax.crypto.SecretKey;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlEncrypt
extends AbstractXmlCipher {
    public XmlEncrypt(int mode, SecretKey secretKey) throws UtilsException {
        super(1, secretKey);
    }

    public XmlEncrypt(int mode, SecretKey secretKey, boolean addBouncyCastleProvider) throws UtilsException {
        super(1, secretKey, addBouncyCastleProvider);
    }

    public XmlEncrypt(String keyAlgorithm, boolean addBouncyCastleProvider) throws UtilsException {
        super(1, keyAlgorithm, addBouncyCastleProvider);
    }

    public XmlEncrypt(String keyAlgorithm) throws UtilsException {
        super(1, keyAlgorithm);
    }

    public XmlEncrypt(Certificate certificate, boolean addBouncyCastleProvider) throws UtilsException {
        super(1, certificate, addBouncyCastleProvider);
    }

    public XmlEncrypt(Certificate certificate) throws UtilsException {
        super(1, certificate);
    }

    public XmlEncrypt(Key key, boolean addBouncyCastleProvider) throws UtilsException {
        super(1, key, addBouncyCastleProvider);
    }

    public XmlEncrypt(Key key) throws UtilsException {
        super(1, key);
    }

    public XmlEncrypt(KeyStore keystore, boolean addBouncyCastleProvider) throws UtilsException {
        super(1, keystore, addBouncyCastleProvider);
    }

    public XmlEncrypt(KeyStore keystore) throws UtilsException {
        super(1, keystore);
    }

    public XmlEncrypt(KeyStore keystore, String alias, boolean addBouncyCastleProvider) throws UtilsException {
        super(1, keystore, alias, addBouncyCastleProvider);
    }

    public XmlEncrypt(KeyStore keystore, String alias) throws UtilsException {
        super(1, keystore, alias);
    }

    public XmlEncrypt(KeyStore keystore, String alias, String passwordPrivateKey, boolean addBouncyCastleProvider) throws UtilsException {
        super(1, keystore, alias, passwordPrivateKey, addBouncyCastleProvider);
    }

    public XmlEncrypt(KeyStore keystore, String alias, String passwordPrivateKey) throws UtilsException {
        super(1, keystore, alias, passwordPrivateKey);
    }

    public Document encrypt(Document document, String encryptAlgorithm) throws UtilsException {
        return this.encrypt(document, document.getDocumentElement(), encryptAlgorithm, null, null);
    }

    public Document encrypt(Document document, String encryptAlgorithm, String keyAlgorithm, String wrappedKeyAlgorithm) throws UtilsException {
        return this.encrypt(document, document.getDocumentElement(), encryptAlgorithm, keyAlgorithm, wrappedKeyAlgorithm);
    }

    public Document encrypt(Element element, String encryptAlgorithm) throws UtilsException {
        return this.encrypt(element.getOwnerDocument(), element, encryptAlgorithm, null, null);
    }

    public Document encrypt(Element element, String encryptAlgorithm, String keyAlgorithm, String wrappedKeyAlgorithm) throws UtilsException {
        return this.encrypt(element.getOwnerDocument(), element, encryptAlgorithm, keyAlgorithm, wrappedKeyAlgorithm);
    }

    public Document encrypt(Document document, Element element, String encryptAlgorithm) throws UtilsException {
        return this.encrypt(document, element, encryptAlgorithm, null, null);
    }

    public Document encrypt(Document document, Element element, String encryptAlgorithm, String keyAlgorithm, String wrappedKeyAlgorithm) throws UtilsException {
        try {
            if (encryptAlgorithm == null) {
                throw new UtilsException("Encrypt Algorithm undefined");
            }
            EncryptedKey encryptedKey = null;
            if (super.isEncryptedKey()) {
                if (wrappedKeyAlgorithm == null) {
                    throw new UtilsException("WrappedKeyAlgorithm undefined");
                }
                XMLCipher xmlCipherWrappedAlgorithm = super.getXMLCipherWrappedKey(wrappedKeyAlgorithm);
                if (keyAlgorithm == null) {
                    throw new UtilsException("KeyAlgorithm undefined");
                }
                this.secretKey = AbstractXmlCipher.generateSecretKey(keyAlgorithm);
                encryptedKey = xmlCipherWrappedAlgorithm.encryptKey(document, (Key)this.secretKey);
            }
            XMLCipher xmlCipher = super.getXMLCipher(encryptAlgorithm);
            if (encryptedKey != null) {
                EncryptedData encryptedData = xmlCipher.getEncryptedData();
                KeyInfo info = new KeyInfo(document);
                info.add(encryptedKey);
                encryptedData.setKeyInfo(info);
            }
            return xmlCipher.doFinal(document, element, true);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

