/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.security;

import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.security.AbstractXmlCipher;
import it.link.pdd.tools.migrazione_govway.utils.security.KeyStore;
import it.link.pdd.tools.migrazione_govway.utils.xml.DynamicNamespaceContext;
import it.link.pdd.tools.migrazione_govway.utils.xml.XPathExpressionEngine;
import it.link.pdd.tools.migrazione_govway.utils.xml.XPathReturnType;
import java.security.Key;
import java.security.cert.Certificate;
import javax.crypto.SecretKey;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlDecrypt
extends AbstractXmlCipher {
    public XmlDecrypt(int mode, SecretKey secretKey) throws UtilsException {
        super(2, secretKey);
    }

    public XmlDecrypt(int mode, SecretKey secretKey, boolean addBouncyCastleProvider) throws UtilsException {
        super(2, secretKey, addBouncyCastleProvider);
    }

    public XmlDecrypt(Certificate certificate, boolean addBouncyCastleProvider) throws UtilsException {
        super(2, certificate, addBouncyCastleProvider);
    }

    public XmlDecrypt(Certificate certificate) throws UtilsException {
        super(2, certificate);
    }

    public XmlDecrypt(Key key, boolean addBouncyCastleProvider) throws UtilsException {
        super(2, key, addBouncyCastleProvider);
    }

    public XmlDecrypt(Key key) throws UtilsException {
        super(2, key);
    }

    public XmlDecrypt(KeyStore keystore, boolean addBouncyCastleProvider) throws UtilsException {
        super(2, keystore, addBouncyCastleProvider);
    }

    public XmlDecrypt(KeyStore keystore) throws UtilsException {
        super(2, keystore);
    }

    public XmlDecrypt(KeyStore keystore, String alias, boolean addBouncyCastleProvider) throws UtilsException {
        super(2, keystore, alias, addBouncyCastleProvider);
    }

    public XmlDecrypt(KeyStore keystore, String alias) throws UtilsException {
        super(2, keystore, alias);
    }

    public XmlDecrypt(KeyStore keystore, String alias, String passwordPrivateKey, boolean addBouncyCastleProvider) throws UtilsException {
        super(2, keystore, alias, passwordPrivateKey, addBouncyCastleProvider);
    }

    public XmlDecrypt(KeyStore keystore, String alias, String passwordPrivateKey) throws UtilsException {
        super(2, keystore, alias, passwordPrivateKey);
    }

    public Document decrypt(Document document) throws UtilsException {
        return this.decrypt(document, document.getDocumentElement());
    }

    public Document decrypt(Element element) throws UtilsException {
        return this.decrypt(element.getOwnerDocument(), element);
    }

    public Document decrypt(Document document, Element element) throws UtilsException {
        try {
            XPathExpressionEngine xpathEngine = new XPathExpressionEngine();
            DynamicNamespaceContext dnc = new DynamicNamespaceContext();
            dnc.findPrefixNamespace(element);
            Element encryptedDataElement = null;
            Object o = xpathEngine.getMatchPattern(element, dnc, "//{http://www.w3.org/2001/04/xmlenc#}EncryptedData", XPathReturnType.NODE);
            if (o == null) {
                throw new Exception("EncryptData not found");
            }
            encryptedDataElement = (Element)o;
            Element encryptedKeyElement = null;
            if (super.isEncryptedKey()) {
                o = xpathEngine.getMatchPattern(encryptedDataElement, dnc, "//{http://www.w3.org/2001/04/xmlenc#}EncryptedKey", XPathReturnType.NODE);
                if (o == null) {
                    throw new Exception("EncryptedKey not found");
                }
                encryptedKeyElement = (Element)o;
            }
            XMLCipher xmlCipherReaderAlgo = super.getXMLCipher();
            EncryptedData encryptedData = xmlCipherReaderAlgo.loadEncryptedData(document, encryptedDataElement);
            EncryptedKey encryptedKey = null;
            if (super.isEncryptedKey()) {
                encryptedKey = xmlCipherReaderAlgo.loadEncryptedKey(document, encryptedKeyElement);
            }
            String encryptAlgorithm = encryptedData.getEncryptionMethod().getAlgorithm();
            if (super.isEncryptedKey()) {
                XMLCipher xmlCipherUnwrap = super.getXMLCipherUnwrappedKey();
                this.secretKey = (SecretKey)xmlCipherUnwrap.decryptKey(encryptedKey, encryptAlgorithm);
            }
            XMLCipher xmlCipher = super.getXMLCipher(encryptAlgorithm);
            return xmlCipher.doFinal(document, encryptedDataElement);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

