/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.security;

import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.security.KeyStore;
import it.link.pdd.tools.migrazione_govway.utils.xml.DynamicNamespaceContext;
import it.link.pdd.tools.migrazione_govway.utils.xml.XPathExpressionEngine;
import it.link.pdd.tools.migrazione_govway.utils.xml.XPathReturnType;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.XMLSignature;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VerifyXmlSignature {
    private KeyStore keystore;
    private Certificate certificate;

    public VerifyXmlSignature(KeyStore keystore) throws UtilsException {
        this(keystore, null, false);
    }

    public VerifyXmlSignature(KeyStore keystore, String alias) throws UtilsException {
        this(keystore, alias, false);
    }

    public VerifyXmlSignature(KeyStore keystore, boolean addBouncyCastleProvider) throws UtilsException {
        this(keystore, null, addBouncyCastleProvider);
    }

    public VerifyXmlSignature(KeyStore keystore, String alias, boolean addBouncyCastleProvider) throws UtilsException {
        this.keystore = keystore;
        this.certificate = alias == null ? this.keystore.getCertificate() : this.keystore.getCertificate(alias);
        try {
            if (addBouncyCastleProvider) {
                BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
                Security.addProvider((Provider)bouncyCastleProvider);
            }
            Init.init();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public boolean verify(Document element, boolean clean) throws UtilsException {
        return this._verify(element.getDocumentElement(), clean);
    }

    public boolean verify(Element element, boolean clean) throws UtilsException {
        return this._verify(element, clean);
    }

    private boolean _verify(Element element, boolean clean) throws UtilsException {
        try {
            XPathExpressionEngine xpathEngine = new XPathExpressionEngine();
            DynamicNamespaceContext dnc = new DynamicNamespaceContext();
            dnc.findPrefixNamespace(element);
            Object o = xpathEngine.getMatchPattern(element, dnc, "//{http://www.w3.org/2000/09/xmldsig#}Signature", XPathReturnType.NODE);
            if (o == null) {
                throw new Exception("Signature element not found");
            }
            Node signatureElement = (Node)o;
            XMLSignature sigXMLSec = new XMLSignature((Element)signatureElement, null);
            boolean valida = sigXMLSec.checkSignatureValue((X509Certificate)this.certificate);
            if (clean) {
                element.removeChild(signatureElement);
            }
            return valida;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

