/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.security;

import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.resources.FileSystemUtilities;
import it.link.pdd.tools.migrazione_govway.utils.security.KeyStore;
import it.link.pdd.tools.migrazione_govway.utils.security.Signature;
import it.link.pdd.tools.migrazione_govway.utils.security.VerifySignature;
import it.link.pdd.tools.migrazione_govway.utils.security.VerifyXmlSignature;
import it.link.pdd.tools.migrazione_govway.utils.security.XmlSignature;
import it.link.pdd.tools.migrazione_govway.utils.xml.PrettyPrintXMLUtils;
import it.link.pdd.tools.migrazione_govway.utils.xml.XMLUtils;
import java.io.File;
import java.io.InputStream;
import org.w3c.dom.Element;

public class TestSignature {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        InputStream isKeystore = null;
        File fKeystore = null;
        InputStream isTruststore = null;
        File fTruststore = null;
        try {
            isKeystore = TestSignature.class.getResourceAsStream("/it.link.pdd.tools.migrazione_govway.utils/security/keystore_example.jks");
            fKeystore = File.createTempFile("keystore", "jks");
            FileSystemUtilities.writeFile(fKeystore, Utilities.getAsByteArray(isKeystore));
            isTruststore = TestSignature.class.getResourceAsStream("/it.link.pdd.tools.migrazione_govway.utils/security/truststore_example.jks");
            fTruststore = File.createTempFile("truststore", "jks");
            FileSystemUtilities.writeFile(fTruststore, Utilities.getAsByteArray(isTruststore));
            String passwordChiavePrivata = "key123456";
            String passwordStore = "123456";
            String alias = "openspcoop";
            KeyStore keystore = new KeyStore(fKeystore.getAbsolutePath(), passwordStore);
            KeyStore truststore = new KeyStore(fTruststore.getAbsolutePath(), passwordStore);
            System.out.println("\n\n ================================");
            System.out.println("1. Example JavaSignature \n");
            String contenutoDaFirmare = "MarioRossi:23:05:1980";
            String signedAlgorithm = "SHA1WithRSA";
            Signature signature = new Signature(keystore, alias, passwordChiavePrivata);
            byte[] signed = signature.sign(contenutoDaFirmare.getBytes(), signedAlgorithm);
            System.out.println("1. JavaSignature Signed: " + new String(signed));
            VerifySignature verify = new VerifySignature(truststore, alias);
            System.out.println("1. JavaSignature Verify: " + verify.verify(contenutoDaFirmare.getBytes(), signed, signedAlgorithm));
            System.out.println("\n\n ================================");
            System.out.println("2. Example XmlSignature \n");
            String xmlInput = "<prova><test>VALORE</test></prova>";
            Element node = XMLUtils.getInstance().newElement(xmlInput.getBytes());
            XmlSignature xmlSignature = new XmlSignature(keystore, alias, passwordChiavePrivata);
            xmlSignature.addX509KeyInfo();
            xmlSignature.sign(node);
            System.out.println("2. XmlSignature Signed: " + PrettyPrintXMLUtils.prettyPrintWithTrAX(node));
            VerifyXmlSignature xmlVerify = new VerifyXmlSignature(truststore, alias);
            System.out.println("2. XmlSignature Verify (no clean): " + xmlVerify.verify(node, false));
            System.out.println("2. XmlSignature Verify (no clean) xml: " + PrettyPrintXMLUtils.prettyPrintWithTrAX(node));
            System.out.println("2. XmlSignature Verify (clean): " + xmlVerify.verify(node, true));
            System.out.println("2. XmlSignature Verify (clean) xml: " + PrettyPrintXMLUtils.prettyPrintWithTrAX(node));
        }
        finally {
            try {
                if (isKeystore != null) {
                    isKeystore.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fKeystore != null) {
                    fKeystore.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (isTruststore != null) {
                    isTruststore.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fTruststore != null) {
                    fTruststore.delete();
                }
            }
            catch (Exception exception) {}
        }
    }
}

