/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.security;

import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.resources.FileSystemUtilities;
import it.link.pdd.tools.migrazione_govway.utils.security.AbstractXmlCipher;
import it.link.pdd.tools.migrazione_govway.utils.security.Decrypt;
import it.link.pdd.tools.migrazione_govway.utils.security.Encrypt;
import it.link.pdd.tools.migrazione_govway.utils.security.KeyStore;
import it.link.pdd.tools.migrazione_govway.utils.security.TestSignature;
import it.link.pdd.tools.migrazione_govway.utils.security.XmlDecrypt;
import it.link.pdd.tools.migrazione_govway.utils.security.XmlEncrypt;
import it.link.pdd.tools.migrazione_govway.utils.xml.PrettyPrintXMLUtils;
import it.link.pdd.tools.migrazione_govway.utils.xml.XMLUtils;
import java.io.File;
import java.io.InputStream;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class TestEncrypt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        InputStream isKeystore = null;
        File fKeystore = null;
        InputStream isTruststore = null;
        File fTruststore = null;
        try {
            isKeystore = TestSignature.class.getResourceAsStream("/it.link.pdd.tools.migrazione_govway.utils/security/keystore_example.jks");
            fKeystore = File.createTempFile("keystore", "jks");
            FileSystemUtilities.writeFile(fKeystore, Utilities.getAsByteArray(isKeystore));
            isTruststore = TestSignature.class.getResourceAsStream("/it.link.pdd.tools.migrazione_govway.utils/security/truststore_example.jks");
            fTruststore = File.createTempFile("truststore", "jks");
            FileSystemUtilities.writeFile(fTruststore, Utilities.getAsByteArray(isTruststore));
            String passwordChiavePrivata = "key123456";
            String passwordStore = "123456";
            String alias = "openspcoop";
            KeyStore keystore = new KeyStore(fKeystore.getAbsolutePath(), passwordStore);
            KeyStore truststore = new KeyStore(fTruststore.getAbsolutePath(), passwordStore);
            System.out.println("\n\n ================================");
            System.out.println("1. Example JavaEncrypt \n");
            String contenutoDaCifrare = "MarioRossi:23:05:1980";
            String encryptAlgorithm = "RSA";
            Encrypt encrypt = new Encrypt(keystore, alias, passwordChiavePrivata);
            byte[] encryptedBytes = encrypt.encrypt(contenutoDaCifrare.getBytes(), encryptAlgorithm);
            System.out.println("1a. JavaEncrypt Encrypted (Private): " + new String(encryptedBytes));
            Decrypt decrypt = new Decrypt(truststore, alias);
            System.out.println("1a. JavaEncrypt Decrypted (Public): " + new String(decrypt.decrypt(encryptedBytes, encryptAlgorithm)));
            encrypt = new Encrypt(truststore, alias);
            encryptedBytes = encrypt.encrypt(contenutoDaCifrare.getBytes(), encryptAlgorithm);
            System.out.println("1b. JavaEncrypt Encrypted (Public): " + new String(encryptedBytes));
            decrypt = new Decrypt(keystore, alias, passwordChiavePrivata);
            System.out.println("1b. JavaEncrypt Decrypted (Private): " + new String(decrypt.decrypt(encryptedBytes, encryptAlgorithm)));
            System.out.println("\n\n ================================");
            System.out.println("2. Example XmlSignature \n");
            String xmlInput = "<prova><test>VALORE</test></prova>";
            Element node = XMLUtils.getInstance().newElement(xmlInput.getBytes());
            String keyAlgorithm = "AES";
            SecretKey secretKey = AbstractXmlCipher.generateSecretKey(keyAlgorithm);
            encryptAlgorithm = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
            XmlEncrypt xmlEncrypt = new XmlEncrypt(secretKey);
            xmlEncrypt.encrypt(node, encryptAlgorithm);
            System.out.println("2a. XmlSignature Encrypted (SymmetricKey): " + PrettyPrintXMLUtils.prettyPrintWithTrAX(node));
            XmlDecrypt xmlDecrypt = new XmlDecrypt(secretKey);
            xmlDecrypt.decrypt(node);
            System.out.println("2b. XmlSignature Decrypted (SymmetricKey): " + PrettyPrintXMLUtils.prettyPrintWithTrAX(node));
            keyAlgorithm = "AES";
            encryptAlgorithm = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
            String wrappedKeyAlgorithm = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            xmlEncrypt = new XmlEncrypt(keystore, alias, passwordChiavePrivata);
            xmlEncrypt.encrypt(node, encryptAlgorithm, keyAlgorithm, wrappedKeyAlgorithm);
            System.out.println("2b. XmlSignature Encrypted (Private): " + PrettyPrintXMLUtils.prettyPrintWithTrAX(node));
            xmlDecrypt = new XmlDecrypt(truststore, alias);
            xmlDecrypt.decrypt(node);
            System.out.println("2b. XmlSignature Decrypted (Public): " + PrettyPrintXMLUtils.prettyPrintWithTrAX(node));
            xmlEncrypt = new XmlEncrypt(truststore, alias);
            xmlEncrypt.encrypt(node, encryptAlgorithm, keyAlgorithm, wrappedKeyAlgorithm);
            System.out.println("2c. XmlSignature Encrypted (Public): " + PrettyPrintXMLUtils.prettyPrintWithTrAX(node));
            xmlDecrypt = new XmlDecrypt(keystore, alias, passwordChiavePrivata);
            xmlDecrypt.decrypt(node);
            System.out.println("2c. XmlSignature Decrypted (Private): " + PrettyPrintXMLUtils.prettyPrintWithTrAX(node));
        }
        finally {
            try {
                if (isKeystore != null) {
                    isKeystore.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fKeystore != null) {
                    fKeystore.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (isTruststore != null) {
                    isTruststore.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fTruststore != null) {
                    fTruststore.delete();
                }
            }
            catch (Exception exception) {}
        }
    }
}

