/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.security;

import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Enumeration;

public class KeyStore {
    private java.security.KeyStore keystore;

    public KeyStore(String keystorePath, String passwordKeystore) throws UtilsException {
        this(keystorePath, "JKS", passwordKeystore);
    }

    public KeyStore(String keystorePath, String tipoKeystore, String passwordKeystore) throws UtilsException {
        this(new File(keystorePath), tipoKeystore, passwordKeystore);
    }

    public KeyStore(File keystorePath, String passwordKeystore) throws UtilsException {
        this(keystorePath, "JKS", passwordKeystore);
    }

    public KeyStore(File keystorePath, String tipoKeystore, String passwordKeystore) throws UtilsException {
        if (!keystorePath.exists()) {
            throw new UtilsException("Keystore [" + keystorePath + "] not exists");
        }
        if (!keystorePath.canRead()) {
            throw new UtilsException("Keystore [" + keystorePath + "] cannot read");
        }
        InputStream fin = null;
        try {
            java.security.KeyStore keystore = java.security.KeyStore.getInstance(tipoKeystore);
            fin = new FileInputStream(keystorePath);
            keystore.load(fin, passwordKeystore.toCharArray());
            this.keystore = keystore;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public PrivateKey getPrivateKey(String alias, String passwordPrivateKey) throws UtilsException {
        try {
            return (PrivateKey)this.keystore.getKey(alias, passwordPrivateKey.toCharArray());
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public Certificate getCertificate() throws UtilsException {
        try {
            Enumeration<String> aliases = this.keystore.aliases();
            Certificate cer = null;
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (cer != null) {
                    throw new Exception("More than one certificate, use alias");
                }
                cer = this.keystore.getCertificate(alias);
            }
            return cer;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public Certificate getCertificate(String alias) throws UtilsException {
        try {
            return this.keystore.getCertificate(alias);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

