/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.security;

import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.security.KeyStore;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.XMLCipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public abstract class AbstractXmlCipher {
    private Key key;
    private Certificate certificate;
    private int mode;
    protected SecretKey secretKey;
    private boolean encryptedKey = true;

    public boolean isEncryptedKey() {
        return this.encryptedKey;
    }

    protected AbstractXmlCipher(int mode, SecretKey secretKey) throws UtilsException {
        this(mode, secretKey, false);
    }

    protected AbstractXmlCipher(int mode, SecretKey secretKey, boolean addBouncyCastleProvider) throws UtilsException {
        this.initSymmetric(mode, secretKey, addBouncyCastleProvider);
    }

    protected AbstractXmlCipher(int mode, String keyAlgorithm) throws UtilsException {
        this(mode, keyAlgorithm, false);
    }

    protected AbstractXmlCipher(int mode, String keyAlgorithm, boolean addBouncyCastleProvider) throws UtilsException {
        this(mode, AbstractXmlCipher.generateSecretKey(keyAlgorithm), addBouncyCastleProvider);
    }

    private void initSymmetric(int mode, SecretKey secretKey, boolean addBouncyCastleProvider) throws UtilsException {
        this.mode = mode;
        this.secretKey = secretKey;
        this.encryptedKey = false;
        this.init(addBouncyCastleProvider);
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public static SecretKey generateSecretKey(String algorithm) throws UtilsException {
        KeyGenerator keyGenerator = null;
        try {
            keyGenerator = KeyGenerator.getInstance(algorithm);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        return keyGenerator.generateKey();
    }

    protected AbstractXmlCipher(int mode, Key key) throws UtilsException {
        this(mode, key, false);
    }

    protected AbstractXmlCipher(int mode, Key key, boolean addBouncyCastleProvider) throws UtilsException {
        if (key instanceof SecretKey) {
            this.initSymmetric(mode, (SecretKey)key, addBouncyCastleProvider);
        } else {
            this.mode = mode;
            this.key = key;
            this.init(addBouncyCastleProvider);
        }
    }

    protected AbstractXmlCipher(int mode, KeyStore keystore, String alias, String passwordPrivateKey) throws UtilsException {
        this(mode, keystore, alias, passwordPrivateKey, false);
    }

    protected AbstractXmlCipher(int mode, KeyStore keystore, String alias, String passwordPrivateKey, boolean addBouncyCastleProvider) throws UtilsException {
        this.mode = mode;
        this.key = keystore.getPrivateKey(alias, passwordPrivateKey);
        this.init(addBouncyCastleProvider);
    }

    protected AbstractXmlCipher(int mode, Certificate certificate) throws UtilsException {
        this(mode, certificate, false);
    }

    protected AbstractXmlCipher(int mode, Certificate certificate, boolean addBouncyCastleProvider) throws UtilsException {
        this.mode = mode;
        this.certificate = certificate;
        this.init(addBouncyCastleProvider);
    }

    protected AbstractXmlCipher(int mode, KeyStore keystore, String alias) throws UtilsException {
        this(mode, keystore, alias, false);
    }

    protected AbstractXmlCipher(int mode, KeyStore keystore, String alias, boolean addBouncyCastleProvider) throws UtilsException {
        this.mode = mode;
        this.certificate = keystore.getCertificate(alias);
        this.init(addBouncyCastleProvider);
    }

    protected AbstractXmlCipher(int mode, KeyStore keystore) throws UtilsException {
        this(mode, keystore, false);
    }

    protected AbstractXmlCipher(int mode, KeyStore keystore, boolean addBouncyCastleProvider) throws UtilsException {
        this.mode = mode;
        this.certificate = keystore.getCertificate();
        this.init(addBouncyCastleProvider);
    }

    private void init(boolean addBouncyCastleProvider) throws UtilsException {
        try {
            if (addBouncyCastleProvider) {
                BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
                Security.addProvider((Provider)bouncyCastleProvider);
            }
            Init.init();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    protected XMLCipher getXMLCipher() throws UtilsException {
        try {
            XMLCipher xmlCipher = XMLCipher.getInstance();
            xmlCipher.init(this.mode, null);
            return xmlCipher;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    protected XMLCipher getXMLCipher(String algorithm) throws UtilsException {
        try {
            XMLCipher xmlCipher = XMLCipher.getInstance((String)algorithm);
            xmlCipher.init(this.mode, (Key)this.secretKey);
            return xmlCipher;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    protected XMLCipher getXMLCipherUnwrappedKey() throws UtilsException {
        return this.getXMLCipherWrappedKey(null);
    }

    protected XMLCipher getXMLCipherWrappedKey(String algorithm) throws UtilsException {
        try {
            XMLCipher xmlCipher = null;
            xmlCipher = algorithm != null ? XMLCipher.getInstance((String)algorithm) : XMLCipher.getInstance();
            int wrapMode = -1;
            wrapMode = 1 == this.mode ? 3 : 4;
            if (this.key != null) {
                xmlCipher.init(wrapMode, this.key);
            } else {
                xmlCipher.init(wrapMode, (Key)this.certificate.getPublicKey());
            }
            return xmlCipher;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

