/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.security;

import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.security.KeyStore;
import java.security.Key;
import java.security.cert.Certificate;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public abstract class AbstractCipher {
    private Key key;
    private Certificate certificate;
    private int mode;

    protected AbstractCipher(int mode, Key key) throws UtilsException {
        this.mode = mode;
        this.key = key;
    }

    protected AbstractCipher(int mode, KeyStore keystore, String alias, String passwordPrivateKey) throws UtilsException {
        this.mode = mode;
        this.key = keystore.getPrivateKey(alias, passwordPrivateKey);
    }

    protected AbstractCipher(int mode, byte[] secretKey, String algorithm) throws UtilsException {
        this.mode = mode;
        this.key = new SecretKeySpec(secretKey, algorithm);
    }

    protected AbstractCipher(int mode, Certificate certificate) throws UtilsException {
        this.mode = mode;
        this.certificate = certificate;
    }

    protected AbstractCipher(int mode, KeyStore keystore, String alias) throws UtilsException {
        this.mode = mode;
        this.certificate = keystore.getCertificate(alias);
    }

    protected AbstractCipher(int mode, KeyStore keystore) throws UtilsException {
        this.mode = mode;
        this.certificate = keystore.getCertificate();
    }

    protected byte[] process(String data, String charsetName, String algorithm) throws UtilsException {
        try {
            return this.process(data.getBytes(charsetName), algorithm);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    protected byte[] process(byte[] data, String algorithm) throws UtilsException {
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            if (this.key != null) {
                cipher.init(this.mode, this.key);
            } else {
                cipher.init(this.mode, this.certificate);
            }
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

