/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.resources;

import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Properties;
import org.slf4j.Logger;

public class TransportUtils {
    public static String buildLocationWithURLBasedParameter(Properties propertiesURLBased, String location) {
        return TransportUtils.buildLocationWithURLBasedParameter(propertiesURLBased, location, LoggerWrapperFactory.getLogger(TransportUtils.class));
    }

    public static String buildLocationWithURLBasedParameter(Properties propertiesURLBased, String location, Logger log) {
        if (propertiesURLBased != null && propertiesURLBased.size() > 0) {
            StringBuffer urlBuilder = new StringBuffer(location);
            Enumeration<Object> enumForm = propertiesURLBased.keys();
            while (enumForm.hasMoreElements()) {
                if (!urlBuilder.toString().contains("?")) {
                    urlBuilder.append("?");
                } else {
                    urlBuilder.append("&");
                }
                String key = (String)enumForm.nextElement();
                String value = (String)propertiesURLBased.get(key);
                try {
                    key = URLEncoder.encode(key, "UTF8");
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                    log.error("URLEncode [key] error: " + e.getMessage(), (Throwable)e);
                }
                try {
                    value = URLEncoder.encode(value, "UTF8");
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                    log.error("URLEncode [value] error: " + e.getMessage(), (Throwable)e);
                }
                String keyValue = key + "=" + value;
                urlBuilder.append(keyValue);
            }
            return urlBuilder.toString();
        }
        return location;
    }

    public static String limitLocation255Character(String location) {
        if (location.length() > 255) {
            return location.substring(0, 251) + " ...";
        }
        return location;
    }
}

