/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.resources;

import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.resources.Loader;
import it.link.pdd.tools.migrazione_govway.utils.resources.SSLConfig;
import it.link.pdd.tools.migrazione_govway.utils.resources.SSLHostNameVerifierDisabled;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;

public class SSLUtilities {
    public static List<String> getSSLEnabledProtocols(String sslType) throws UtilsException {
        try {
            ArrayList<String> p = new ArrayList<String>();
            SSLContext context = SSLContext.getInstance(sslType);
            context.init(null, null, null);
            SSLSocket socket = (SSLSocket)context.getSocketFactory().createSocket();
            String[] protocols = socket.getEnabledProtocols();
            for (int i = 0; i < protocols.length; ++i) {
                p.add(protocols[i]);
            }
            return p;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static List<String> getSSLSupportedProtocols() throws UtilsException {
        try {
            ArrayList<String> p = new ArrayList<String>();
            SSLContext defaultContext = SSLContext.getDefault();
            SSLSocket socket = (SSLSocket)defaultContext.getSocketFactory().createSocket();
            String[] protocols = socket.getSupportedProtocols();
            for (int i = 0; i < protocols.length; ++i) {
                p.add(protocols[i]);
            }
            return p;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static String getSafeDefaultProtocol() {
        try {
            return SSLUtilities.getDefaultProtocol();
        }
        catch (Exception e) {
            return "TLS";
        }
    }

    public static String getDefaultProtocol() throws UtilsException {
        List<String> p = SSLUtilities.getSSLSupportedProtocols();
        if (p.contains("TLSv1.2")) {
            return "TLSv1.2";
        }
        if (p.contains("TLSv1.1")) {
            return "TLSv1.1";
        }
        if (p.contains("TLSv1")) {
            return "TLSv1";
        }
        if (p.contains("TLS")) {
            return "TLS";
        }
        if (p.contains("SSLv3")) {
            return "SSLv3";
        }
        if (p.contains("SSL")) {
            return "SSL";
        }
        if (p.contains("SSLv2Hello")) {
            return "SSLv2Hello";
        }
        return p.get(0);
    }

    public static List<String> getAllSslProtocol() {
        ArrayList<String> p = new ArrayList<String>();
        p.add("TLSv1.2");
        p.add("TLSv1.1");
        p.add("TLSv1");
        p.add("TLS");
        p.add("SSLv3");
        p.add("SSL");
        p.add("SSLv2Hello");
        try {
            List<String> pTmp = SSLUtilities.getSSLSupportedProtocols();
            for (String s : pTmp) {
                if (p.contains(s)) continue;
                p.add(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return p;
    }

    public static List<String> getSSLEnabledCipherSuites(String sslType) throws UtilsException {
        try {
            ArrayList<String> l = new ArrayList<String>();
            SSLContext context = SSLContext.getInstance(sslType);
            context.init(null, null, null);
            SSLSocket socket = (SSLSocket)context.getSocketFactory().createSocket();
            String[] cs = socket.getEnabledCipherSuites();
            for (int i = 0; i < cs.length; ++i) {
                l.add(cs[i]);
            }
            return l;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static List<String> getSSLSupportedCipherSuites() throws UtilsException {
        try {
            ArrayList<String> l = new ArrayList<String>();
            SSLContext defaultContext = SSLContext.getDefault();
            SSLSocket socket = (SSLSocket)defaultContext.getSocketFactory().createSocket();
            String[] cs = socket.getSupportedCipherSuites();
            for (int i = 0; i < cs.length; ++i) {
                l.add(cs[i]);
            }
            return l;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static List<Provider> getSSLProviders() throws UtilsException {
        try {
            ArrayList<Provider> p = new ArrayList<Provider>();
            for (Provider provider : Security.getProviders()) {
                p.add(provider);
            }
            return p;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static List<String> getSSLProvidersName() throws UtilsException {
        try {
            ArrayList<String> p = new ArrayList<String>();
            for (Provider provider : Security.getProviders()) {
                p.add(provider.getName());
            }
            return p;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static List<String> getServiceTypes(Provider provider) throws UtilsException {
        try {
            ArrayList<String> p = new ArrayList<String>();
            for (Provider.Service service : provider.getServices()) {
                if (p.contains(service.getType())) continue;
                p.add(service.getType());
            }
            return p;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static List<String> getServiceTypeAlgorithms(Provider provider, String serviceType) throws UtilsException {
        try {
            ArrayList<String> p = new ArrayList<String>();
            for (Provider.Service service : provider.getServices()) {
                if (!serviceType.equals(service.getType())) continue;
                p.add(service.getAlgorithm());
            }
            return p;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static SSLContext generateSSLContext(SSLConfig sslConfig, StringBuffer bfLog) throws UtilsException {
        SSLContext sslContext = null;
        bfLog.append("Creo contesto SSL...\n");
        KeyManager[] km = null;
        TrustManager[] tm = null;
        FileInputStream finKeyStore = null;
        FileInputStream finTrustStore = null;
        try {
            Object truststore;
            if (sslConfig.getKeyStoreLocation() != null) {
                bfLog.append("Gestione keystore...\n");
                bfLog.append("\tKeystore type[" + sslConfig.getKeyStoreType() + "]\n");
                bfLog.append("\tKeystore location[" + sslConfig.getKeyStoreLocation() + "]\n");
                bfLog.append("\tKeystore keyManagementAlgorithm[" + sslConfig.getKeyManagementAlgorithm() + "]\n");
                KeyStore keystore = KeyStore.getInstance(sslConfig.getKeyStoreType());
                finKeyStore = new FileInputStream(sslConfig.getKeyStoreLocation());
                keystore.load(finKeyStore, sslConfig.getKeyStorePassword().toCharArray());
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(sslConfig.getKeyManagementAlgorithm());
                keyManagerFactory.init(keystore, sslConfig.getKeyPassword().toCharArray());
                km = keyManagerFactory.getKeyManagers();
                bfLog.append("Gestione keystore effettuata\n");
            }
            if (sslConfig.getTrustStoreLocation() != null) {
                bfLog.append("Gestione truststore...\n");
                bfLog.append("\tTruststore type[" + sslConfig.getTrustStoreType() + "]\n");
                bfLog.append("\tTruststore location[" + sslConfig.getTrustStoreLocation() + "]\n");
                bfLog.append("\tTruststore trustManagementAlgorithm[" + sslConfig.getTrustManagementAlgorithm() + "]\n");
                truststore = KeyStore.getInstance(sslConfig.getTrustStoreType());
                finTrustStore = new FileInputStream(sslConfig.getTrustStoreLocation());
                ((KeyStore)truststore).load(finTrustStore, sslConfig.getTrustStorePassword().toCharArray());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(sslConfig.getTrustManagementAlgorithm());
                trustManagerFactory.init((KeyStore)truststore);
                tm = trustManagerFactory.getTrustManagers();
                bfLog.append("Gestione truststore effettuata\n");
            }
            bfLog.append("Init SSLContext type[" + sslConfig.getSslType() + "] ...\n");
            sslContext = SSLContext.getInstance(sslConfig.getSslType());
            sslContext.init(km, tm, null);
            bfLog.append("Init SSLContext type[" + sslConfig.getSslType() + "] effettuato\n");
            truststore = sslContext;
            return truststore;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (finKeyStore != null) {
                    finKeyStore.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (finTrustStore != null) {
                    finTrustStore.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static HostnameVerifier generateHostnameVerifier(SSLConfig sslConfig, StringBuffer bfLog, Logger log, Loader loader) throws UtilsException {
        try {
            if (sslConfig.isHostnameVerifier()) {
                if (sslConfig.getClassNameHostnameVerifier() != null) {
                    bfLog.append("HostNamve verifier enabled [" + sslConfig.getClassNameHostnameVerifier() + "]\n");
                    HostnameVerifier verifica = (HostnameVerifier)loader.newInstance(sslConfig.getClassNameHostnameVerifier());
                    return verifica;
                }
                bfLog.append("HostName verifier enabled\n");
                return null;
            }
            bfLog.append("HostName verifier disabled\n");
            SSLHostNameVerifierDisabled disabilitato = new SSLHostNameVerifierDisabled(log);
            return disabilitato;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void setSSLContextIntoJavaProperties(SSLConfig sslConfig, StringBuffer bfLog) throws UtilsException {
        bfLog.append("Creo contesto SSL...\n");
        try {
            if (sslConfig.getKeyStoreLocation() != null) {
                bfLog.append("Gestione keystore...\n");
                System.setProperty("javax.net.ssl.keyStore", sslConfig.getKeyStoreLocation());
                if (sslConfig.getKeyStoreType() != null) {
                    System.setProperty("javax.net.ssl.keyStoreType", sslConfig.getKeyStoreType());
                }
                if (sslConfig.getKeyStorePassword() != null) {
                    System.setProperty("javax.net.ssl.keyStorePassword", sslConfig.getKeyStorePassword());
                }
                if (sslConfig.getKeyPassword() != null) {
                    System.setProperty("javax.net.ssl.keyStorePassword", sslConfig.getKeyStorePassword());
                    if (sslConfig.getKeyStorePassword() != null && !sslConfig.getKeyPassword().equals(sslConfig.getKeyStorePassword())) {
                        throw new UtilsException("Keystore and key password in java must be equals");
                    }
                }
                bfLog.append("Gestione keystore effettuata\n");
            }
            if (sslConfig.getTrustStoreLocation() != null) {
                bfLog.append("Gestione truststore...\n");
                System.setProperty("javax.net.ssl.trustStore", sslConfig.getTrustStoreLocation());
                if (sslConfig.getKeyStoreType() != null) {
                    System.setProperty("javax.net.ssl.trustStoreType", sslConfig.getTrustStoreType());
                }
                if (sslConfig.getKeyStorePassword() != null) {
                    System.setProperty("javax.net.ssl.trustStorePassword", sslConfig.getTrustStorePassword());
                }
                bfLog.append("Gestione truststore effettuata\n");
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

