/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.resources;

import it.link.pdd.tools.migrazione_govway.utils.resources.CollectionProperties;
import it.link.pdd.tools.migrazione_govway.utils.resources.PropertiesReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;

public class PropertiesUtilities {
    public static CollectionProperties searchLocalImplementation(String OPENSPCOOP2_LOCAL_HOME, Logger log, String variabile, String path, String confDirectory) {
        return PropertiesUtilities.searchLocalImplementation(OPENSPCOOP2_LOCAL_HOME, log, variabile, path, confDirectory, true);
    }

    public static CollectionProperties searchLocalImplementation(String OPENSPCOOP2_LOCAL_HOME, Logger log, String variabile, String path, String confDirectory, boolean readCallsNotSynchronized) {
        Properties p6;
        Properties p5;
        Properties p4;
        Properties p3;
        Properties p2;
        CollectionProperties cp = new CollectionProperties();
        Properties p1 = PropertiesUtilities.examineStep1(log, variabile);
        if (p1 != null) {
            cp.setSystemVariable(new PropertiesReader(p1, readCallsNotSynchronized));
        }
        if ((p2 = PropertiesUtilities.examineStep2(log, variabile)) != null) {
            cp.setJavaVariable(new PropertiesReader(p2, readCallsNotSynchronized));
        }
        if ((p3 = PropertiesUtilities.examineStep3(OPENSPCOOP2_LOCAL_HOME, log, path)) != null) {
            cp.setSystemOpenSPCoopHome(new PropertiesReader(p3, readCallsNotSynchronized));
        }
        if ((p4 = PropertiesUtilities.examineStep4(OPENSPCOOP2_LOCAL_HOME, log, path)) != null) {
            cp.setJavaOpenSPCoopHome(new PropertiesReader(p4, readCallsNotSynchronized));
        }
        if ((p5 = PropertiesUtilities.examineStep5(log, path)) != null) {
            cp.setClasspath(new PropertiesReader(p5, readCallsNotSynchronized));
        }
        File fConfDirectory = null;
        if (confDirectory != null) {
            fConfDirectory = new File(confDirectory);
        }
        if (fConfDirectory != null && fConfDirectory.exists() && fConfDirectory.isDirectory() && (p6 = PropertiesUtilities.examineStep6(log, path, fConfDirectory)) != null) {
            cp.setConfigDir(new PropertiesReader(p6, readCallsNotSynchronized));
        }
        return cp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties examineStep1(Logger log, String variabile) {
        String file = System.getenv(variabile);
        String subject = "Variabile di sistema " + variabile;
        if (file != null) {
            File ffile = new File(file);
            if (!ffile.exists()) {
                log.error("[" + subject + "] File non esistente: " + ffile.getAbsolutePath());
                return null;
            }
            if (!ffile.canRead()) {
                log.error("[" + subject + "] File non accessibile: " + ffile.getAbsolutePath());
                return null;
            }
            FileInputStream is = null;
            try {
                is = new FileInputStream(ffile);
                Properties properties = PropertiesUtilities.getPropertiesReader(log, is, subject);
                return properties;
            }
            catch (IOException e) {
                log.error("[" + subject + "] file di properties non utilizzabile: " + e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties examineStep2(Logger log, String variabile) {
        String file = System.getProperty(variabile);
        String subject = "Proprieta' di sistema " + variabile;
        if (file != null) {
            File ffile = new File(file);
            if (!ffile.exists()) {
                log.error("[" + subject + "] File non esistente: " + ffile.getAbsolutePath());
                return null;
            }
            if (!ffile.canRead()) {
                log.error("[" + subject + "] File non accessibile: " + ffile.getAbsolutePath());
                return null;
            }
            FileInputStream is = null;
            try {
                is = new FileInputStream(ffile);
                Properties properties = PropertiesUtilities.getPropertiesReader(log, is, subject);
                return properties;
            }
            catch (IOException e) {
                log.error("[" + subject + "] file di properties non utilizzabile: " + e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    private static Properties examineStep3(String OPENSPCOOP2_LOCAL_HOME, Logger log, String path) {
        String dir = System.getenv(OPENSPCOOP2_LOCAL_HOME);
        String subject = "Variabile di sistema " + OPENSPCOOP2_LOCAL_HOME;
        if (dir != null) {
            File fDir = new File(dir);
            if (!fDir.exists()) {
                log.error("[" + subject + "] Directory non esistente: " + fDir.getAbsolutePath());
                return null;
            }
            if (!fDir.canRead()) {
                log.error("[" + subject + "] Directory non accessibile: " + fDir.getAbsolutePath());
                return null;
            }
            return PropertiesUtilities.getPropertiesReader(log, fDir.getAbsolutePath() + File.separatorChar + path, subject);
        }
        return null;
    }

    private static Properties examineStep4(String OPENSPCOOP2_LOCAL_HOME, Logger log, String path) {
        String dir = System.getProperty(OPENSPCOOP2_LOCAL_HOME);
        String subject = "Proprieta' di sistema " + OPENSPCOOP2_LOCAL_HOME;
        if (dir != null) {
            File fDir = new File(dir);
            if (!fDir.exists()) {
                log.error("[" + subject + "] Directory non esistente: " + fDir.getAbsolutePath());
                return null;
            }
            if (!fDir.canRead()) {
                log.error("[" + subject + "] Directory non accessibile: " + fDir.getAbsolutePath());
                return null;
            }
            return PropertiesUtilities.getPropertiesReader(log, fDir.getAbsolutePath() + File.separatorChar + path, subject);
        }
        return null;
    }

    private static Properties examineStep5(Logger log, String path) {
        return PropertiesUtilities.getPropertiesReader(log, PropertiesUtilities.class.getResourceAsStream("/" + path), "CLASSPATH: " + path);
    }

    private static Properties examineStep6(Logger log, String path, File fConfDirectory) {
        File f = new File(fConfDirectory, path);
        if (f.exists()) {
            return PropertiesUtilities.getPropertiesReader(log, f.getAbsolutePath(), "CONFIG_DIR_OPENSPCOOP/" + path);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getPropertiesReader(Logger log, String path, String subject) {
        if (path != null) {
            File f = new File(path);
            if (!f.exists()) {
                return null;
            }
            if (!f.canRead()) {
                log.error("[" + subject + "] file di properties non accessibile: " + f.getAbsolutePath());
                return null;
            }
            FileInputStream is = null;
            try {
                is = new FileInputStream(f);
                Properties properties = PropertiesUtilities.getPropertiesReader(log, is, subject);
                return properties;
            }
            catch (IOException e) {
                log.error("[" + subject + "] file di properties non utilizzabile: " + e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getPropertiesReader(Logger log, InputStream is, String subject) {
        if (is != null) {
            Properties propertiesReader = null;
            try {
                propertiesReader = new Properties();
                propertiesReader.load(is);
            }
            catch (IOException e) {
                propertiesReader = null;
                log.error("[" + subject + "] file di properties non utilizzabile: " + e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            if (propertiesReader != null) {
                return propertiesReader;
            }
            return null;
        }
        return null;
    }
}

