/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.resources;

import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.resources.MapReader;
import java.util.Enumeration;
import java.util.Properties;

public class PropertiesReader
extends MapReader<Object, Object> {
    public PropertiesReader(Properties properties, boolean readCallsNotSynchronized) {
        super(properties, readCallsNotSynchronized);
    }

    @Override
    public String getValue(String key) throws UtilsException {
        Object valueObject = super.getValue(key);
        if (valueObject != null) {
            if (!(valueObject instanceof String)) {
                throw new UtilsException("Proprieta '" + key + "' non e' di tipo java.lang.String (trovato tipo: [" + valueObject.getClass().getName() + "] valore: [" + valueObject + "])");
            }
            String value = (String)valueObject;
            return value.trim();
        }
        return null;
    }

    public String convertEnvProperties(String value) throws UtilsException {
        return this.convertEnvProperties(value, false);
    }

    public String convertEnvProperties(String value, boolean convertKeyEnvProperties) throws UtilsException {
        String label = "del valore";
        if (convertKeyEnvProperties) {
            label = "della chiave";
        }
        if (value.indexOf("${") != -1) {
            while (value.indexOf("${") != -1) {
                int indexStart = value.indexOf("${");
                int indexEnd = value.indexOf("}");
                if (indexEnd == -1) {
                    throw new UtilsException("Errore durante l'interpretazione " + label + " [" + value + "]: ${ utilizzato senza la rispettiva chiusura }");
                }
                String nameSystemProperty = value.substring(indexStart + "${".length(), indexEnd);
                String valueSystemProperty = System.getProperty(nameSystemProperty);
                if (valueSystemProperty == null) {
                    throw new UtilsException("Errore durante l'interpretazione " + label + " [" + value + "]: variabile di sistema ${" + nameSystemProperty + "} non esistente");
                }
                value = value.replace("${" + nameSystemProperty + "}", valueSystemProperty);
            }
        }
        return value;
    }

    public String getValue_convertEnvProperties(String key) throws UtilsException {
        String value = this.getValue(key);
        if (value != null) {
            value = this.convertEnvProperties(value);
        }
        return value;
    }

    public Properties readProperties(String prefix) throws UtilsException {
        Properties prop = new Properties();
        try {
            Enumeration keys = this.keys();
            while (keys.hasMoreElements()) {
                String value;
                String property;
                Object keyIt = keys.nextElement();
                if (!(keyIt instanceof String) || !(property = (String)keyIt).startsWith(prefix)) continue;
                String key = property.substring(prefix.length());
                if (key != null) {
                    key = key.trim();
                }
                if ((value = this.getValue(property)) != null) {
                    value = value.trim();
                }
                if (key == null || value == null) continue;
                prop.setProperty(key, value);
            }
            return prop;
        }
        catch (Exception e) {
            throw new UtilsException("readProperties Riscontrato errore durante la lettura delle propriete con prefisso [" + prefix + "]: " + e.getMessage(), e);
        }
    }

    public Properties readProperties_convertEnvProperties(String prefix) throws UtilsException {
        return this.readProperties_convertEnvProperties(prefix, false);
    }

    public Properties readProperties_convertEnvProperties(String prefix, boolean convertKeyEnvProperties) throws UtilsException {
        Properties prop = new Properties();
        try {
            Properties prop_tmp = this.readProperties(prefix);
            Enumeration<?> en = prop_tmp.propertyNames();
            while (en.hasMoreElements()) {
                String property = (String)en.nextElement();
                String value = prop_tmp.getProperty(property);
                if (value != null) {
                    value = value.trim();
                    value = this.convertEnvProperties(value);
                }
                if (property == null || value == null) continue;
                if (convertKeyEnvProperties) {
                    prop.setProperty(this.convertEnvProperties(property, true), value);
                    continue;
                }
                prop.setProperty(property, value);
            }
            return prop;
        }
        catch (Exception e) {
            throw new UtilsException("readProperties Riscontrato errore durante la lettura delle propriete con prefisso [" + prefix + "]: " + e.getMessage(), e);
        }
    }

    public Enumeration<?> propertyNames() {
        return this.keys();
    }
}

