/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.resources;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.collections.iterators.IteratorEnumeration;

public class MapReader<K, V> {
    protected Map<K, V> javaMap;
    protected boolean readCallsNotSynchronized = false;
    protected FastHashMap fastMap;

    public MapReader(Map<K, V> map, boolean readCallsNotSynchronized) {
        this.readCallsNotSynchronized = readCallsNotSynchronized;
        if (this.readCallsNotSynchronized) {
            this.fastMap = new FastHashMap(map);
            this.fastMap.setFast(true);
        } else {
            this.javaMap = map;
        }
    }

    public V get(K key) {
        return this.getValue(key);
    }

    public V getValue(K key) {
        Object o = null;
        o = this.readCallsNotSynchronized ? this.fastMap.get(key) : this.javaMap.get(key);
        if (o == null) {
            return null;
        }
        return (V)o;
    }

    public Enumeration<K> keys() {
        if (this.readCallsNotSynchronized) {
            return new IteratorEnumeration(this.fastMap.keySet().iterator());
        }
        return new IteratorEnumeration(this.javaMap.keySet().iterator());
    }

    public Collection<V> values() {
        if (this.readCallsNotSynchronized) {
            return this.fastMap.values();
        }
        return this.javaMap.values();
    }

    public Enumeration<V> elements() {
        return new IteratorEnumeration(this.values().iterator());
    }

    public boolean containsKey(K key) {
        if (this.readCallsNotSynchronized) {
            return this.fastMap.containsKey(key);
        }
        return this.javaMap.containsKey(key);
    }

    public int size() {
        if (this.readCallsNotSynchronized) {
            return this.fastMap.size();
        }
        return this.javaMap.size();
    }
}

