/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.resources;

import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.resources.CollectionProperties;
import it.link.pdd.tools.migrazione_govway.utils.resources.PropertiesReader;
import it.link.pdd.tools.migrazione_govway.utils.resources.PropertiesUtilities;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.slf4j.Logger;

public abstract class InstanceProperties {
    private PropertiesReader propertiesOriginale;
    private CollectionProperties propertiesRidefinitoFile;
    private PropertiesReader propertiesRidefinitoObject;
    protected Logger log;
    private String OPENSPCOOP2_LOCAL_HOME;
    private boolean readCallsNotSynchronized;

    public InstanceProperties(String OPENSPCOOP2_LOCAL_HOME, Properties propertiesOriginale, Logger log) throws Exception {
        this(OPENSPCOOP2_LOCAL_HOME, propertiesOriginale, log, true);
    }

    public InstanceProperties(String OPENSPCOOP2_LOCAL_HOME, Properties propertiesOriginale, Logger log, boolean readCallsNotSynchronized) throws Exception {
        this.propertiesOriginale = new PropertiesReader(propertiesOriginale, readCallsNotSynchronized);
        this.log = log;
        if (this.log == null) {
            this.log = LoggerWrapperFactory.getLogger(InstanceProperties.class);
        }
        this.OPENSPCOOP2_LOCAL_HOME = OPENSPCOOP2_LOCAL_HOME;
        this.readCallsNotSynchronized = readCallsNotSynchronized;
    }

    public void setLocalFileImplementation(String variable, String path, String confDirectory) {
        CollectionProperties prop = PropertiesUtilities.searchLocalImplementation(this.OPENSPCOOP2_LOCAL_HOME, this.log, variable, path, confDirectory, this.readCallsNotSynchronized);
        if (prop != null) {
            this.propertiesRidefinitoFile = prop;
        }
    }

    public void setLocalFileImplementation(CollectionProperties prop) {
        this.propertiesRidefinitoFile = prop;
    }

    public void setLocalObjectImplementation(Properties prop) {
        this.propertiesRidefinitoObject = new PropertiesReader(prop, this.readCallsNotSynchronized);
    }

    public String getValue(String key) throws UtilsException {
        return this.getValueEngine(key, false);
    }

    public String getValue_convertEnvProperties(String key) throws UtilsException {
        return this.getValueEngine(key, true);
    }

    public Properties readProperties(String prefix) throws UtilsException {
        return this.readPropertiesEngine(prefix, false);
    }

    public Properties readProperties_convertEnvProperties(String prefix) throws UtilsException {
        return this.readPropertiesEngine(prefix, true);
    }

    public String convertEnvProperties(String value) throws UtilsException {
        return this.propertiesOriginale.convertEnvProperties(value);
    }

    public Enumeration<?> propertyNames() {
        String ridefinito;
        Enumeration<?> enumPropRidefinito;
        Enumeration<?> enumProp = this.propertiesOriginale.propertyNames();
        Vector<String> object = new Vector<String>();
        while (enumProp.hasMoreElements()) {
            object.add((String)enumProp.nextElement());
        }
        if (this.propertiesRidefinitoFile != null) {
            enumPropRidefinito = this.propertiesRidefinitoFile.propertyNames();
            while (enumPropRidefinito != null && enumPropRidefinito.hasMoreElements()) {
                ridefinito = (String)enumPropRidefinito.nextElement();
                if (object.contains(ridefinito)) continue;
                object.add(ridefinito);
            }
        }
        if (this.propertiesRidefinitoObject != null) {
            enumPropRidefinito = this.propertiesRidefinitoObject.propertyNames();
            while (enumPropRidefinito != null && enumPropRidefinito.hasMoreElements()) {
                ridefinito = (String)enumPropRidefinito.nextElement();
                if (object.contains(ridefinito)) continue;
                object.add(ridefinito);
            }
        }
        return object.elements();
    }

    private String getValueEngine(String key, boolean convertEnvProperties) throws UtilsException {
        try {
            int i;
            String tmp;
            String[] addObject = null;
            boolean appendObject = false;
            String tmpObject = null;
            if (this.propertiesRidefinitoObject != null) {
                tmpObject = convertEnvProperties ? this.propertiesRidefinitoObject.getValue_convertEnvProperties(key) : this.propertiesRidefinitoObject.getValue(key);
            }
            if (tmpObject != null) {
                tmpObject = tmpObject.trim();
                String add = null;
                if (tmpObject.startsWith("+")) {
                    appendObject = true;
                    add = tmpObject.substring(1);
                    add = add.trim();
                }
                if (add != null) {
                    if (add.startsWith(",") && add.length() > 1) {
                        addObject = add.substring(1).split(",");
                        if (addObject != null && addObject.length > 0) {
                            for (int i2 = 0; i2 < addObject.length; ++i2) {
                                addObject[i2] = addObject[i2].trim();
                            }
                        } else {
                            addObject = new String[]{tmpObject};
                        }
                    }
                } else {
                    addObject = new String[]{tmpObject};
                }
            }
            String[] addFile = null;
            boolean appendFile = false;
            String tmpFile = null;
            if (this.propertiesRidefinitoFile != null) {
                tmpFile = convertEnvProperties ? this.propertiesRidefinitoFile.getValue_convertEnvProperties(key) : this.propertiesRidefinitoFile.getValue(key);
            }
            if (tmpFile != null) {
                tmpFile = tmpFile.trim();
                String add = null;
                if (tmpFile.startsWith("+")) {
                    appendFile = true;
                    add = tmpFile.substring(1);
                    add = add.trim();
                }
                if (add != null) {
                    if (add.startsWith(",") && add.length() > 1) {
                        addFile = add.substring(1).split(",");
                        if (addFile != null && addFile.length > 0) {
                            for (int i3 = 0; i3 < addFile.length; ++i3) {
                                addFile[i3] = addFile[i3].trim();
                            }
                        } else {
                            addFile = new String[]{tmpFile};
                        }
                    }
                } else {
                    addFile = new String[]{tmpFile};
                }
            }
            if ((tmp = null) == null) {
                tmp = convertEnvProperties ? this.propertiesOriginale.getValue_convertEnvProperties(key) : this.propertiesOriginale.getValue(key);
            }
            if (addObject == null && addFile == null) {
                return tmp;
            }
            if (!appendObject && !appendFile) {
                if (addObject != null) {
                    return addObject[0];
                }
                if (addFile != null) {
                    return addFile[0];
                }
                return tmp;
            }
            StringBuffer bf = new StringBuffer();
            ArrayList<String> valoriAggiunti = new ArrayList<String>();
            if (addObject != null) {
                for (i = 0; i < addObject.length; ++i) {
                    if (valoriAggiunti.contains(addObject[i])) continue;
                    if (bf.length() > 0) {
                        bf.append(",");
                    }
                    bf.append(addObject[i]);
                    valoriAggiunti.add(addObject[i]);
                }
            }
            if (addFile != null) {
                for (i = 0; i < addFile.length; ++i) {
                    if (valoriAggiunti.contains(addFile[i])) continue;
                    if (bf.length() > 0) {
                        bf.append(",");
                    }
                    bf.append(addFile[i]);
                    valoriAggiunti.add(addFile[i]);
                }
            }
            if (tmp != null && !valoriAggiunti.contains(tmp)) {
                if (bf.length() > 0) {
                    bf.append(",");
                }
                bf.append(tmp);
                valoriAggiunti.add(tmp);
            }
            return bf.toString();
        }
        catch (Exception e) {
            this.log.error("Errore durante la lettura della proprieta' [" + key + "](" + convertEnvProperties + ")", (Throwable)e);
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private Properties readPropertiesEngine(String prefix, boolean convertEnvProperties) throws UtilsException {
        Properties tmp = null;
        try {
            String key;
            Enumeration<Object> keys;
            tmp = convertEnvProperties ? this.propertiesOriginale.readProperties_convertEnvProperties(prefix) : this.propertiesOriginale.readProperties(prefix);
            if (this.propertiesRidefinitoFile != null) {
                Properties tmp2 = null;
                tmp2 = convertEnvProperties ? this.propertiesRidefinitoFile.readProperties_convertEnvProperties(prefix) : this.propertiesRidefinitoFile.readProperties(prefix);
                if (tmp2 != null) {
                    keys = tmp2.keys();
                    while (keys.hasMoreElements()) {
                        key = (String)keys.nextElement();
                        if (tmp.containsKey(key)) {
                            tmp.remove(key);
                        }
                        tmp.put(key, tmp2.get(key));
                    }
                }
            }
            if (this.propertiesRidefinitoObject != null) {
                Properties tmp3 = null;
                tmp3 = convertEnvProperties ? this.propertiesRidefinitoObject.readProperties_convertEnvProperties(prefix) : this.propertiesRidefinitoObject.readProperties(prefix);
                if (tmp3 != null) {
                    keys = tmp3.keys();
                    while (keys.hasMoreElements()) {
                        key = (String)keys.nextElement();
                        if (tmp.containsKey(key)) {
                            tmp.remove(key);
                        }
                        tmp.put(key, tmp3.get(key));
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante la lettura delle proprieta' con prefix [" + prefix + "](" + convertEnvProperties + ")", (Throwable)e);
            throw new UtilsException(e.getMessage(), e);
        }
        return tmp;
    }
}

