/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.resources;

import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.resources.FileSystemUtilities;
import it.link.pdd.tools.migrazione_govway.utils.resources.HttpBodyParameters;
import it.link.pdd.tools.migrazione_govway.utils.resources.HttpResponseBody;
import it.link.pdd.tools.migrazione_govway.utils.resources.HttpUtilsException;
import it.link.pdd.tools.migrazione_govway.utils.resources.MimeTypes;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.soap.encoding.soapenc.Base64;

public class HttpUtilities {
    public static final int HTTP_CONNECTION_TIMEOUT = 10000;
    public static final int HTTP_READ_CONNECTION_TIMEOUT = 120000;
    public static final String HEADER_X_DOWNLOAD = "application/x-download";
    public static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String HEADER_ATTACH_FILE = "attachment; filename=";

    public static List<String> getClientAddressHeaders() throws UtilsException {
        ArrayList<String> possibiliHeaders = new ArrayList<String>();
        possibiliHeaders.add("X-Forwarded-For");
        possibiliHeaders.add("Forwarded-For");
        possibiliHeaders.add("X-Forwarded");
        possibiliHeaders.add("Forwarded");
        possibiliHeaders.add("X-Client-IP");
        possibiliHeaders.add("Client-IP");
        possibiliHeaders.add("X-Cluster-Client-IP");
        possibiliHeaders.add("Cluster-Client-IP");
        return possibiliHeaders;
    }

    public static String getClientAddress(HttpServletRequest request) throws UtilsException {
        try {
            return HttpUtilities.getClientAddress(HttpUtilities.getClientAddressHeaders(), request);
        }
        catch (Throwable e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private static String getClientAddress(List<String> headers, HttpServletRequest request) throws UtilsException {
        if (headers.size() > 0) {
            for (String header : headers) {
                String transportAddr = request.getHeader(header);
                if (transportAddr != null) {
                    return transportAddr;
                }
                transportAddr = request.getHeader(header.toLowerCase());
                if (transportAddr != null) {
                    return transportAddr;
                }
                transportAddr = request.getHeader(header.toUpperCase());
                if (transportAddr == null) continue;
                return transportAddr;
            }
        }
        return null;
    }

    public static String getClientAddress(Properties transportProperties) throws UtilsException {
        try {
            return HttpUtilities.getClientAddress(HttpUtilities.getClientAddressHeaders(), transportProperties);
        }
        catch (Throwable e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private static String getClientAddress(List<String> headers, Properties transportProperties) throws UtilsException {
        if (headers.size() > 0) {
            for (String header : headers) {
                String transportAddr = transportProperties.getProperty(header);
                if (transportAddr != null) {
                    return transportAddr;
                }
                transportAddr = transportProperties.getProperty(header.toLowerCase());
                if (transportAddr != null) {
                    return transportAddr;
                }
                transportAddr = transportProperties.getProperty(header.toUpperCase());
                if (transportAddr == null) continue;
                return transportAddr;
            }
        }
        return null;
    }

    public static String getHttpReason(int status) {
        if (status == 100) {
            return "Continue";
        }
        if (status == 101) {
            return "Switching Protocols";
        }
        if (status == 102) {
            return "Processing";
        }
        if (status == 200) {
            return "OK";
        }
        if (status == 201) {
            return "Created";
        }
        if (status == 202) {
            return "Accepted";
        }
        if (status == 203) {
            return "Non-Authoritative Information";
        }
        if (status == 204) {
            return "No Content";
        }
        if (status == 205) {
            return "Reset Content";
        }
        if (status == 206) {
            return "Partial Content";
        }
        if (status == 207) {
            return "Multi-Status";
        }
        if (status == 208) {
            return "Already Reported";
        }
        if (status == 226) {
            return "IM Used";
        }
        if (status == 300) {
            return "Multiple Choices";
        }
        if (status == 301) {
            return "Moved Permanently";
        }
        if (status == 302) {
            return "Found";
        }
        if (status == 303) {
            return "See Other";
        }
        if (status == 304) {
            return "Not Modified";
        }
        if (status == 305) {
            return "Use Proxy";
        }
        if (status == 306) {
            return "Switch Proxy";
        }
        if (status == 307) {
            return "Temporary Redirect";
        }
        if (status == 308) {
            return "Permanent Redirect";
        }
        if (status == 400) {
            return "Bad Request";
        }
        if (status == 401) {
            return "Unauthorized";
        }
        if (status == 402) {
            return "Payment Required";
        }
        if (status == 403) {
            return "Forbidden";
        }
        if (status == 404) {
            return "Not Found";
        }
        if (status == 405) {
            return "Method Not Allowed";
        }
        if (status == 406) {
            return "Not Acceptable";
        }
        if (status == 407) {
            return "Proxy Authentication Required";
        }
        if (status == 408) {
            return "Request Timeout";
        }
        if (status == 409) {
            return "Conflict";
        }
        if (status == 410) {
            return "Gone";
        }
        if (status == 411) {
            return "Length Required";
        }
        if (status == 412) {
            return "Precondition Failed";
        }
        if (status == 413) {
            return "Payload Too Large";
        }
        if (status == 414) {
            return "URI Too Long";
        }
        if (status == 415) {
            return "Unsupported Media Type";
        }
        if (status == 416) {
            return "Range Not Satisfiable";
        }
        if (status == 417) {
            return "Expectation Failed";
        }
        if (status == 419) {
            return "Authentication Timeout";
        }
        if (status == 421) {
            return "Misdirected Request";
        }
        if (status == 422) {
            return "Unprocessable Entity";
        }
        if (status == 423) {
            return "Locked";
        }
        if (status == 424) {
            return "Failed Dependency";
        }
        if (status == 426) {
            return "Upgrade Required";
        }
        if (status == 428) {
            return "Precondition Required";
        }
        if (status == 429) {
            return "Too Many Requests";
        }
        if (status == 431) {
            return "Request Header Fields Too Large";
        }
        if (status == 451) {
            return "Unavailable For Legal Reasons";
        }
        if (status == 500) {
            return "Internal Server Error";
        }
        if (status == 501) {
            return "Not Implemented";
        }
        if (status == 502) {
            return "Bad Gateway";
        }
        if (status == 503) {
            return "Service Unavailable";
        }
        if (status == 504) {
            return "Gateway Timeout";
        }
        if (status == 505) {
            return "HTTP Version Not Supported";
        }
        if (status == 506) {
            return "Variant Also Negotiates";
        }
        if (status == 507) {
            return "Insufficient Storage";
        }
        if (status == 508) {
            return "Loop Detected";
        }
        if (status == 509) {
            return "Bandwidth Limit Exceeded";
        }
        if (status == 510) {
            return "Not Extended";
        }
        if (status == 511) {
            return "Network Authentication Required";
        }
        return null;
    }

    public static void setOutputFile(HttpServletResponse response, boolean noCache, String fileName) throws UtilsException {
        String mimeType = null;
        if (fileName.contains(".")) {
            String ext = null;
            try {
                ext = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
            }
            catch (Exception exception) {
                // empty catch block
            }
            MimeTypes mimeTypes = MimeTypes.getInstance();
            mimeType = ext != null && mimeTypes.existsExtension(ext) ? mimeTypes.getMimeType(ext) : HEADER_X_DOWNLOAD;
        } else {
            mimeType = HEADER_X_DOWNLOAD;
        }
        HttpUtilities.setOutputFile(response, noCache, fileName, mimeType);
    }

    public static void setOutputFile(HttpServletResponse response, boolean noCache, String fileName, String mimeType) throws UtilsException {
        if (mimeType != null) {
            response.setContentType(mimeType);
        }
        response.setHeader(HEADER_CONTENT_DISPOSITION, "attachment; filename=\"" + fileName + "\"");
        if (noCache) {
            HttpUtilities.setNoCache(response);
        }
    }

    public static void setNoCache(HttpServletResponse response) throws UtilsException {
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    public static void setChunkedStreamingMode(HttpURLConnection httpConn, int chunkLength, String httpMethod, String contentType) throws UtilsException {
        HttpBodyParameters params = new HttpBodyParameters(httpMethod, contentType);
        if (params.isDoOutput()) {
            httpConn.setChunkedStreamingMode(chunkLength);
        }
    }

    public static boolean isHttpBodyPermitted(boolean isRequest, String httpMethod, String contentType) throws UtilsException {
        HttpBodyParameters params = new HttpBodyParameters(httpMethod, contentType);
        if (isRequest) {
            return params.isDoOutput();
        }
        return params.isDoInput();
    }

    public static void setStream(HttpURLConnection httpConn, String httpMethod) throws UtilsException {
        HttpUtilities.setStream(httpConn, httpMethod, null);
    }

    public static void setStream(HttpURLConnection httpConn, String httpMethod, String contentType) throws UtilsException {
        try {
            HttpBodyParameters params = new HttpBodyParameters(httpMethod, contentType);
            HttpUtilities.setHttpMethod(httpConn, httpMethod);
            if (params.isDoOutput()) {
                httpConn.setDoOutput(params.isDoOutput());
            }
            if (params.isDoInput()) {
                httpConn.setDoInput(params.isDoInput());
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void setHttpMethod(HttpURLConnection httpConn, String httpMethod) throws UtilsException {
        block5: {
            try {
                if (HttpUtilities.isHttpMethodStandard(httpMethod)) {
                    httpConn.setRequestMethod(httpMethod);
                    break block5;
                }
                try {
                    HttpUtilities._setProtectedFieldValue(HttpURLConnection.class, "method", httpConn, httpMethod);
                }
                catch (Throwable ex) {
                    throw new Exception("Unsupported Method '" + httpMethod + "' and set by reflection error: " + ex.getMessage(), ex);
                }
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
    }

    private static boolean isHttpMethodStandard(String httpMethod) throws UtilsException {
        try {
            String httpMethodUpperCase;
            switch (httpMethodUpperCase = httpMethod.toUpperCase()) {
                case "GET": 
                case "POST": 
                case "HEAD": 
                case "OPTIONS": 
                case "PUT": 
                case "DELETE": 
                case "TRACE": {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private static void _setProtectedFieldValue(Class<?> clazz, String fieldName, Object object, Object newValue) throws Exception {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            int i;
            Field[] f = clazz.getDeclaredFields();
            System.out.println("================= (size:" + f.length + " class:" + clazz.getName() + " fieldName:" + fieldName + ") ==========================");
            for (i = 0; i < f.length; ++i) {
                System.out.println("NOME[" + f[i].getName() + "] TIPO[" + f[i].getType() + "]");
            }
            f = clazz.getFields();
            System.out.println("================= (FIELDS size:" + f.length + " class:" + clazz.getName() + " fieldName:" + fieldName + ") ==========================");
            for (i = 0; i < f.length; ++i) {
                System.out.println("NOME[" + f[i].getName() + "] TIPO[" + f[i].getType() + "]");
            }
            throw e;
        }
        field.setAccessible(true);
        field.set(object, newValue);
    }

    public static byte[] requestHTTPFile(String path) throws UtilsException {
        return HttpUtilities.requestHTTPFile(path, 120000, 10000, null, null);
    }

    public static byte[] requestHTTPFile(String path, int readTimeout, int connectTimeout) throws UtilsException {
        return HttpUtilities.requestHTTPFile(path, readTimeout, connectTimeout, null, null);
    }

    public static byte[] requestHTTPFile(String path, String username, String password) throws UtilsException {
        return HttpUtilities.requestHTTPFile(path, 120000, 10000, username, password);
    }

    public static byte[] requestHTTPFile(String path, int readTimeout, int connectTimeout, String username, String password) throws UtilsException {
        HttpResponseBody res = HttpUtilities.getHTTPResponse(path, readTimeout, connectTimeout, username, password);
        return res.getResponse();
    }

    public static HttpResponseBody getHTTPResponse(String path) throws UtilsException {
        return HttpUtilities.getHTTPResponse(path, 120000, 10000, null, null);
    }

    public static HttpResponseBody getHTTPResponse(String path, int readTimeout, int connectTimeout) throws UtilsException {
        return HttpUtilities.getHTTPResponse(path, readTimeout, connectTimeout, null, null);
    }

    public static HttpResponseBody getHTTPResponse(String path, String username, String password) throws UtilsException {
        return HttpUtilities.getHTTPResponse(path, 120000, 10000, username, password);
    }

    public static HttpResponseBody getHTTPResponse(String path, int readTimeout, int connectTimeout, String username, String password) throws UtilsException {
        if (path.startsWith("file://")) {
            String filePath = path.substring("file://".length());
            File f = new File(filePath);
            if (!f.exists()) {
                throw new UtilsException("404");
            }
            if (!f.canRead()) {
                throw new UtilsException("404");
            }
            HttpResponseBody response = new HttpResponseBody();
            try {
                response.setResponse(FileSystemUtilities.readBytesFromFile(f));
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
            response.setResultHTTPOperation(200);
            return response;
        }
        InputStream is = null;
        ByteArrayOutputStream outResponse = null;
        try {
            URL url = new URL(path);
            URLConnection connection = url.openConnection();
            HttpURLConnection httpConn = (HttpURLConnection)connection;
            httpConn.setConnectTimeout(connectTimeout);
            httpConn.setReadTimeout(readTimeout);
            if (username != null && password != null) {
                String authentication = username + ":" + password;
                authentication = "Basic " + Base64.encode((byte[])authentication.getBytes());
                httpConn.setRequestProperty("Authorization", authentication);
            }
            HttpUtilities.setStream(httpConn, "GET");
            int resultHTTPOperation = httpConn.getResponseCode();
            if (resultHTTPOperation == 404) {
                throw new UtilsException("404");
            }
            outResponse = new ByteArrayOutputStream();
            if (resultHTTPOperation > 399) {
                is = httpConn.getErrorStream();
                if (is == null) {
                    is = httpConn.getInputStream();
                }
            } else {
                is = httpConn.getInputStream();
                if (is == null) {
                    is = httpConn.getErrorStream();
                }
            }
            byte[] readB = new byte[65536];
            int readByte = 0;
            while ((readByte = is.read(readB)) != -1) {
                outResponse.write(readB, 0, readByte);
            }
            is.close();
            httpConn.disconnect();
            byte[] xmlottenuto = outResponse.toByteArray();
            outResponse.close();
            HttpResponseBody response = new HttpResponseBody();
            response.setResponse(xmlottenuto);
            response.setResultHTTPOperation(resultHTTPOperation);
            return response;
        }
        catch (Exception e) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (outResponse != null) {
                    outResponse.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e.getMessage() != null && e.getMessage().contains("404")) {
                throw new UtilsException("404");
            }
            throw new UtilsException("Utilities.requestHTTPFile error " + e.getMessage(), e);
        }
    }

    public static void check(String path) throws Exception {
        HttpUtilities.check(path, 120000, 10000, null, null);
    }

    public static void check(String path, int readTimeout, int connectTimeout) throws Exception {
        HttpUtilities.check(path, readTimeout, connectTimeout, null, null);
    }

    public static void check(String path, String username, String password) throws Exception {
        HttpUtilities.check(path, 120000, 10000, username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void check(String path, int readTimeout, int connectTimeout, String username, String password) throws Exception {
        InputStream is = null;
        ByteArrayOutputStream outResponse = null;
        HttpURLConnection httpConn = null;
        try {
            URL url = new URL(path);
            URLConnection connection = url.openConnection();
            httpConn = (HttpURLConnection)connection;
            httpConn.setConnectTimeout(connectTimeout);
            httpConn.setReadTimeout(readTimeout);
            if (username != null && password != null) {
                String authentication = username + ":" + password;
                authentication = "Basic " + Base64.encode((byte[])authentication.getBytes());
                httpConn.setRequestProperty("Authorization", authentication);
            }
            HttpUtilities.setStream(httpConn, "GET");
            int resultHTTPOperation = httpConn.getResponseCode();
            if (resultHTTPOperation != 200) {
                if (resultHTTPOperation > 399) {
                    is = httpConn.getErrorStream();
                    if (is == null) {
                        is = httpConn.getInputStream();
                    }
                } else {
                    is = httpConn.getInputStream();
                    if (is == null) {
                        is = httpConn.getErrorStream();
                    }
                }
                if (is != null) {
                    outResponse = new ByteArrayOutputStream();
                    byte[] readB = new byte[65536];
                    int readByte = 0;
                    while ((readByte = is.read(readB)) != -1) {
                        outResponse.write(readB, 0, readByte);
                    }
                    is.close();
                    outResponse.flush();
                    outResponse.close();
                    throw new HttpUtilsException(resultHTTPOperation, "Response Code (" + resultHTTPOperation + "): " + outResponse.toString());
                }
                throw new HttpUtilsException(resultHTTPOperation, "Response Code (" + resultHTTPOperation + ")");
            }
        }
        finally {
            try {
                if (httpConn != null) {
                    httpConn.disconnect();
                }
            }
            catch (Exception exception) {}
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (outResponse != null) {
                    outResponse.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

