/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.resources;

import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class HttpHeaderTypes {
    private Hashtable<String, String> request_standard = new Hashtable();
    private Hashtable<String, String> request_nonStandard = new Hashtable();
    private Hashtable<String, String> response_standard = new Hashtable();
    private Hashtable<String, String> response_nonStandard = new Hashtable();
    private static HttpHeaderTypes httpHeaderTypes = null;

    HttpHeaderTypes() throws UtilsException {
        InputStream is = null;
        BufferedReader br = null;
        InputStreamReader ir = null;
        try {
            String line;
            String file = "/it.link.pdd.tools.migrazione_govway.utils/resources/httpheader.types";
            is = HttpHeaderTypes.class.getResourceAsStream(file);
            if (is == null) {
                throw new Exception("File [" + file + "] in classpath not found");
            }
            ir = new InputStreamReader(is);
            br = new BufferedReader(ir);
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || "".equals(line)) continue;
                String[] tmp = line.split(" ");
                if (tmp.length < 4) {
                    throw new Exception("Line [" + line + "] format wrong");
                }
                String property = tmp[0];
                String richiestaRisposta = tmp[1];
                String standardNonStandard = tmp[2];
                int length = property.length() + 1 + richiestaRisposta.length() + 1 + standardNonStandard.length() + 1;
                String descrizione = line.substring(length);
                if ("[request]".equalsIgnoreCase(richiestaRisposta)) {
                    if ("[standard]".equalsIgnoreCase(standardNonStandard)) {
                        this.request_standard.put(property, descrizione);
                        continue;
                    }
                    if ("[non-standard]".equalsIgnoreCase(standardNonStandard)) {
                        this.request_nonStandard.put(property, descrizione);
                        continue;
                    }
                    throw new Exception("Line [" + line + "] with wrong value [" + standardNonStandard + "] in third parameter (expected: [standard] o [non-standard] )");
                }
                if ("[response]".equalsIgnoreCase(richiestaRisposta)) {
                    if ("[standard]".equalsIgnoreCase(standardNonStandard)) {
                        this.response_standard.put(property, descrizione);
                        continue;
                    }
                    if ("[non-standard]".equalsIgnoreCase(standardNonStandard)) {
                        this.response_nonStandard.put(property, descrizione);
                        continue;
                    }
                    throw new Exception("Line [" + line + "] with wrong value [" + standardNonStandard + "] in third parameter (expected: [standard] o [non-standard] )");
                }
                throw new Exception("Line [" + line + "] with wrong value [" + richiestaRisposta + "] in second parameter (expected: [request] o [response] )");
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ir != null) {
                    ir.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<String> getHeaders() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.getRequestHeaders());
        list.addAll(this.getResponseHeaders());
        return list;
    }

    public List<String> getRequestHeaders() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.getRequestStandardHeaders());
        list.addAll(this.getRequestNonStandardHeaders());
        return list;
    }

    public List<String> getRequestStandardHeaders() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.request_standard.keySet());
        return list;
    }

    public List<String> getRequestNonStandardHeaders() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.request_nonStandard.keySet());
        return list;
    }

    public List<String> getResponseHeaders() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.getResponseStandardHeaders());
        list.addAll(this.getResponseNonStandardHeaders());
        return list;
    }

    public List<String> getResponseStandardHeaders() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.response_standard.keySet());
        return list;
    }

    public List<String> getResponseNonStandardHeaders() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.response_nonStandard.keySet());
        return list;
    }

    private static synchronized void init() throws UtilsException {
        if (httpHeaderTypes == null) {
            httpHeaderTypes = new HttpHeaderTypes();
        }
    }

    public static HttpHeaderTypes getInstance() throws UtilsException {
        if (httpHeaderTypes == null) {
            HttpHeaderTypes.init();
        }
        return httpHeaderTypes;
    }
}

