/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.resources;

import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.slf4j.Logger;

public class GestoreJNDI {
    private Properties contextProperties;
    private static Hashtable<String, Object> localTreeJNDI = new Hashtable();
    public static String LOCAL_TREE_JNDI_PREFIX = "local:/openspcoop2/";

    public GestoreJNDI(Properties contextP) {
        this.contextProperties = contextP;
    }

    public GestoreJNDI() {
        this.contextProperties = new Properties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(String fullPath) throws Exception {
        if (fullPath != null && fullPath.startsWith(LOCAL_TREE_JNDI_PREFIX)) {
            Object o = null;
            Hashtable<String, Object> hashtable = localTreeJNDI;
            synchronized (hashtable) {
                o = localTreeJNDI.get(fullPath);
            }
            if (o == null) {
                throw new UtilsException("LocalResource [" + fullPath + "] not found");
            }
            return o;
        }
        InitialContext ctx = null;
        try {
            Object obj;
            ctx = this.contextProperties != null && this.contextProperties.size() > 0 ? new InitialContext(this.contextProperties) : new InitialContext();
            Object object = obj = ctx.lookup(fullPath);
            return object;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean unbind(String fullPath) {
        return this.unbind(fullPath, null, null);
    }

    public boolean unbind(String fullPath, Logger log) {
        return this.unbind(fullPath, log, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unbind(String fullPath, Logger log, Logger logConsole) {
        if (fullPath != null && fullPath.startsWith(LOCAL_TREE_JNDI_PREFIX)) {
            Object o = null;
            Hashtable<String, Object> hashtable = localTreeJNDI;
            synchronized (hashtable) {
                o = localTreeJNDI.remove(fullPath);
            }
            if (log != null) {
                log.warn("LocalResource [" + fullPath + "] not found");
            }
            if (logConsole != null) {
                logConsole.warn("LocalResource [" + fullPath + "] not found");
            }
            return o != null;
        }
        InitialContext currentContext = null;
        try {
            currentContext = new InitialContext();
            String name = currentContext.composeName(fullPath, currentContext.getNameInNamespace());
            if (log != null) {
                log.debug("Unbind  fullname " + name);
            }
            try {
                currentContext.unbind(name);
            }
            catch (NameNotFoundException ignored) {
                if (log != null) {
                    log.error("Errore durante l'unbind (Ignored) [" + ignored + "]", (Throwable)ignored);
                }
                if (logConsole != null) {
                    logConsole.error("Errore durante l'unbind (Ignored) [" + ignored + "]", (Throwable)ignored);
                }
                boolean bl = false;
                try {
                    if (currentContext != null) {
                        currentContext.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (log != null) {
                log.error("Errore durante l'unbind [" + e + "]", (Throwable)e);
            }
            if (logConsole != null) {
                logConsole.error("Errore durante l'unbind [" + e + "]", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (currentContext != null) {
                    currentContext.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean bind(String fullPath, Object toBind) {
        return this.bind(fullPath, toBind, null, null);
    }

    public boolean bind(String fullPath, Object toBind, Logger log) {
        return this.bind(fullPath, toBind, log, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bind(String fullPath, Object toBind, Logger log, Logger logConsole) {
        if (fullPath != null && fullPath.startsWith(LOCAL_TREE_JNDI_PREFIX)) {
            Hashtable<String, Object> hashtable = localTreeJNDI;
            synchronized (hashtable) {
                if (localTreeJNDI.containsKey(fullPath)) {
                    if (log != null) {
                        log.warn("LocalResource [" + fullPath + "] already exists");
                    }
                    if (logConsole != null) {
                        logConsole.warn("LocalResource [" + fullPath + "] already exists");
                    }
                    return false;
                }
                localTreeJNDI.put(fullPath, toBind);
                return true;
            }
        }
        Context currentContext = null;
        try {
            currentContext = new InitialContext();
            String name = currentContext.composeName(fullPath, currentContext.getNameInNamespace());
            String[] components = name.split("/");
            int stop = components.length - 1;
            for (int ix = 0; ix < stop; ++ix) {
                String nextPath = components[ix];
                try {
                    currentContext = (Context)currentContext.lookup(nextPath);
                    continue;
                }
                catch (NameNotFoundException ignored) {
                    currentContext = currentContext.createSubcontext(nextPath);
                }
            }
            currentContext.bind(components[stop], toBind);
            if (log != null) {
                log.info("binding [" + fullPath + "] to " + currentContext);
            }
            if (logConsole != null) {
                logConsole.info("binding [" + fullPath + "] to " + currentContext);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (log != null) {
                log.error("Errore durante il bind [" + e + "]", (Throwable)e);
            }
            if (logConsole != null) {
                logConsole.error("Errore durante il bind [" + e + "]", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (currentContext != null) {
                    currentContext.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

