/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.resources;

import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import org.slf4j.Logger;

public class DataContentHandlerManager {
    private Logger log;

    public DataContentHandlerManager(Logger log) {
        this.log = log;
    }

    public void initMailcap() {
        byte[] tmp;
        URL url;
        Enumeration<URL> en;
        try {
            this.log.info("Search mailcap.default ...");
            en = DataContentHandlerManager.class.getClassLoader().getResources("/META-INF/mailcap.default");
            if (en != null) {
                while (en.hasMoreElements()) {
                    url = en.nextElement();
                    this.log.info("Find mailcap.default [" + url.toString() + "]");
                    this.log.info("Read mailcap.default [" + url.toString() + "] ...");
                    tmp = Utilities.getAsByteArray(url);
                    this.log.info("Read mailcap.default [" + url.toString() + "]: " + new String(tmp));
                    this.addMimeTypesIntoMailcap(tmp);
                }
            }
        }
        catch (Exception e) {
            this.log.error("Mailcap.default search error: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.log.info("Search mailcap ...");
            en = DataContentHandlerManager.class.getClassLoader().getResources("/META-INF/mailcap");
            if (en != null) {
                while (en.hasMoreElements()) {
                    url = en.nextElement();
                    this.log.info("Find mailcap [" + url.toString() + "]");
                    this.log.info("Read mailcap [" + url.toString() + "] ...");
                    tmp = Utilities.getAsByteArray(url);
                    this.log.info("Read mailcap [" + url.toString() + "]: " + new String(tmp));
                    this.addMimeTypesIntoMailcap(tmp);
                }
            }
        }
        catch (Exception e) {
            this.log.error("Mailcap search error: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<String> readMimeTypesRegistrati() {
        return this.readMimeTypesRegistrati(true);
    }

    public List<String> readMimeTypesRegistrati(boolean debug) {
        MailcapCommandMap mcap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        String[] gestiti = mcap.getMimeTypes();
        ArrayList<String> gestitiAsList = new ArrayList<String>();
        if (gestiti != null) {
            if (debug) {
                this.log.info("MimeTypes registrati: [" + gestiti.length + "]");
            }
            for (int i = 0; i < gestiti.length; ++i) {
                if (debug) {
                    this.log.info("MimeType registrato: [" + gestiti[i] + "]");
                }
                gestitiAsList.add(gestiti[i]);
                CommandInfo[] cis = mcap.getAllCommands(gestiti[i]);
                for (int j = 0; j < cis.length; ++j) {
                    if (!debug) continue;
                    this.log.info("\t[" + j + "] " + cis[j].getCommandName() + " = " + cis[j].getCommandClass());
                }
            }
        } else if (debug) {
            this.log.info("Non risultano registrati MimeTypes");
        }
        return gestitiAsList;
    }

    public Map<String, String> readMimeTypesContentHandler() {
        return this.readMimeTypesContentHandler(true);
    }

    public Map<String, String> readMimeTypesContentHandler(boolean debug) {
        return this._readMimeTypesClass(debug, "content-handler");
    }

    public Map<String, String> readMimeTypesView() {
        return this.readMimeTypesView(true);
    }

    public Map<String, String> readMimeTypesView(boolean debug) {
        return this._readMimeTypesClass(debug, "view");
    }

    public Map<String, String> readMimeTypesEdit() {
        return this.readMimeTypesEdit(true);
    }

    public Map<String, String> readMimeTypesEdit(boolean debug) {
        return this._readMimeTypesClass(debug, "edit");
    }

    private Map<String, String> _readMimeTypesClass(boolean debug, String commandName) {
        MailcapCommandMap mcap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        String[] gestiti = mcap.getMimeTypes();
        HashMap<String, String> map = new HashMap<String, String>();
        if (gestiti != null) {
            if (debug) {
                this.log.info("MimeTypes (" + commandName + ") registrati: [" + gestiti.length + "]");
            }
            for (int i = 0; i < gestiti.length; ++i) {
                CommandInfo[] cis;
                if (debug) {
                    this.log.info("MimeType (" + commandName + ") registrato: [" + gestiti[i] + "]");
                }
                if ((cis = mcap.getAllCommands(gestiti[i])) == null || cis.length <= 0) continue;
                for (int j = 0; j < cis.length; ++j) {
                    if (debug) {
                        this.log.info("\t[" + j + "] " + cis[j].getCommandName() + " = " + cis[j].getCommandClass());
                    }
                    if (!commandName.equalsIgnoreCase(cis[j].getCommandName())) continue;
                    map.put(gestiti[i], cis[j].getCommandClass());
                }
            }
        } else if (debug) {
            this.log.info("Non risultano registrati MimeTypes (" + commandName + ")");
        }
        return map;
    }

    public void addMimeTypeIntoMailcap(String commandInfo) throws UtilsException {
        if (!commandInfo.contains(";;")) {
            throw new UtilsException("Formato non corretto, non \u00e8 stato riscontrato il carattere ';;'");
        }
        String[] split = commandInfo.split(";;");
        if (split == null || split.length != 2) {
            throw new UtilsException("Formato non corretto");
        }
        MailcapCommandMap mcap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mcap.addMailcap(commandInfo);
        CommandMap.setDefaultCommandMap((CommandMap)mcap);
        this.log.info("Registrato in Mailcap il mimetype [" + split[0] + "]: " + commandInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMimeTypesIntoMailcap(byte[] mailcap) throws IOException, UtilsException {
        List<String> gestitiAsList = this.readMimeTypesRegistrati(false);
        BufferedReader br = null;
        InputStreamReader isr = null;
        ByteArrayInputStream bin = null;
        try {
            String strLine;
            bin = new ByteArrayInputStream(mailcap);
            isr = new InputStreamReader(bin);
            br = new BufferedReader(isr);
            while ((strLine = br.readLine()) != null) {
                String[] split;
                if (strLine == null || strLine.startsWith("#") || !strLine.contains(";;") || gestitiAsList.contains((split = strLine.split(";;"))[0])) continue;
                gestitiAsList.add(split[0]);
                this.addMimeTypeIntoMailcap(strLine);
            }
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
            try {
                isr.close();
            }
            catch (Exception exception) {}
            try {
                bin.close();
            }
            catch (Exception exception) {}
        }
    }
}

