/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.regexp;

import it.link.pdd.tools.migrazione_govway.utils.regexp.RegExpException;
import it.link.pdd.tools.migrazione_govway.utils.regexp.RegExpNotFoundException;
import it.link.pdd.tools.migrazione_govway.utils.regexp.RegularExpressionPatternCompileMode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegularExpressionEngine {
    public static String[] getAllStringMatchPattern(String contenuto, String pattern) throws RegExpException, RegExpNotFoundException {
        return RegularExpressionEngine.getAllStringMatchPattern(contenuto, pattern, null);
    }

    public static String[] getAllStringMatchPattern(String contenuto, String pattern, RegularExpressionPatternCompileMode ... compileModes) throws RegExpException, RegExpNotFoundException {
        if (pattern == null || pattern.length() == 0) {
            throw new RegExpNotFoundException("Pattern di ricerca non fornito");
        }
        if (contenuto == null || contenuto.length() == 0) {
            throw new RegExpNotFoundException("Contenuto su cui effettuare una ricerca non fornita");
        }
        try {
            Pattern p = RegularExpressionEngine.createPattern(pattern, compileModes);
            Matcher matcher = p.matcher(contenuto);
            String[] result = null;
            if (matcher.matches()) {
                result = new String[matcher.groupCount()];
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    result[i - 1] = matcher.group(i);
                }
            } else {
                throw new RegExpNotFoundException("nessun match trovato");
            }
            return result;
        }
        catch (RegExpNotFoundException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new RegExpException("getAllStringMatchPattern url[" + contenuto + "] pattern[" + pattern + "] error: " + e.getMessage(), e);
        }
    }

    public static String getStringMatchPattern(String contenuto, String pattern) throws RegExpException, RegExpNotFoundException {
        return RegularExpressionEngine.getStringMatchPattern(contenuto, pattern, null);
    }

    public static String getStringMatchPattern(String contenuto, String pattern, RegularExpressionPatternCompileMode ... compileModes) throws RegExpException, RegExpNotFoundException {
        if (pattern == null || pattern.length() == 0) {
            throw new RegExpNotFoundException("Pattern di ricerca non fornito");
        }
        if (contenuto == null || contenuto.length() == 0) {
            throw new RegExpNotFoundException("Contenuto su cui effettuare una ricerca non fornita");
        }
        try {
            Pattern p = RegularExpressionEngine.createPattern(pattern, compileModes);
            Matcher matcher = p.matcher(contenuto);
            String result = null;
            if (!matcher.matches()) {
                throw new RegExpNotFoundException("nessun match trovato");
            }
            result = matcher.group(1);
            if ("".equals(result)) {
                throw new RegExpNotFoundException("nessun match trovato");
            }
            return result;
        }
        catch (RegExpNotFoundException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new RegExpException("getStringMatchPattern contenuto[" + contenuto + "] pattern[" + pattern + "] error: " + e.getMessage(), e);
        }
    }

    public static boolean isMatch(String contenuto, String pattern) throws RegExpException, RegExpNotFoundException {
        return RegularExpressionEngine.isMatch(contenuto, pattern, null);
    }

    public static boolean isMatch(String contenuto, String pattern, RegularExpressionPatternCompileMode ... compileModes) throws RegExpException, RegExpNotFoundException {
        if (pattern == null || pattern.length() == 0) {
            throw new RegExpNotFoundException("Pattern di ricerca non fornito");
        }
        if (contenuto == null || contenuto.length() == 0) {
            throw new RegExpNotFoundException("Contenuto su cui effettuare una ricerca non fornita");
        }
        try {
            Pattern p = RegularExpressionEngine.createPattern(pattern, compileModes);
            Matcher matcher = p.matcher(contenuto);
            return matcher.matches();
        }
        catch (Exception e) {
            throw new RegExpException("isMatch contenuto[" + contenuto + "] pattern[" + pattern + "] error: " + e.getMessage(), e);
        }
    }

    private static Pattern createPattern(String pattern, RegularExpressionPatternCompileMode ... compileModes) {
        Pattern p = null;
        if (compileModes != null && compileModes.length > 0) {
            int mode = compileModes[0].getPatternCompileMode();
            for (int i = 1; i < compileModes.length; ++i) {
                mode |= compileModes[i].getPatternCompileMode();
            }
            p = Pattern.compile(pattern, mode);
        } else {
            p = Pattern.compile(pattern);
        }
        return p;
    }
}

