/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.regexp;

import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.regexp.RegularExpressionEngine;
import it.link.pdd.tools.migrazione_govway.utils.resources.HttpUtilities;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;

public class RegExpUtilities {
    private static final String oneAlpha = "(.)*((\\p{Alpha})|[-])(.)*";
    private static final String domainIdentifier = "((\\p{Alnum})([-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum})";
    private static final String domainNameRule = "(((\\p{Alnum})([-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum}))((\\.)(((\\p{Alnum})([-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum})))*";

    public static void validateUrl(String url) throws MalformedURLException {
        URL testUrl = new URL(url);
        testUrl.toString();
    }

    public static void validateUri(String uri, boolean checkEsistenzaFile) throws UtilsException, MalformedURLException {
        if (uri.startsWith("http://") || uri.startsWith("file://")) {
            if (checkEsistenzaFile) {
                HttpUtilities.requestHTTPFile(uri);
            } else {
                RegExpUtilities.validateUrl(uri);
            }
        } else {
            File f = new File(uri);
            if (checkEsistenzaFile) {
                if (!f.exists()) {
                    throw new UtilsException("File non esistente");
                }
                if (f.isDirectory()) {
                    throw new UtilsException("File e' una directory");
                }
                if (!f.canRead()) {
                    throw new UtilsException("File non accessibile");
                }
            }
        }
    }

    public static boolean validateDomainName(String domainName) {
        if (domainName == null || domainName.length() > 63) {
            return false;
        }
        return domainName.matches(domainNameRule) && domainName.matches(oneAlpha);
    }

    public static boolean isIPOrHostname(String stringToCheck) {
        boolean ok = true;
        try {
            if (!RegularExpressionEngine.isMatch(stringToCheck, "^[0-9]+.[0-9]+.[0-9]+.[0-9]+$") && !RegExpUtilities.validateDomainName(stringToCheck)) {
                ok = false;
            }
        }
        catch (Exception e) {
            Date now = new Date();
            System.err.println(now + " Exception " + e.getMessage());
        }
        return ok;
    }
}

