/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.mail;

import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.mail.Mail;
import it.link.pdd.tools.migrazione_govway.utils.mail.MailAttach;
import it.link.pdd.tools.migrazione_govway.utils.mail.MailBinaryAttach;
import it.link.pdd.tools.migrazione_govway.utils.mail.MailTextAttach;
import it.link.pdd.tools.migrazione_govway.utils.mail.Sender;
import it.link.pdd.tools.migrazione_govway.utils.resources.FileSystemUtilities;
import it.link.pdd.tools.migrazione_govway.utils.resources.SSLUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.mail.Authenticator;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.commons.mail.SimpleEmail;
import org.slf4j.Logger;

public class CommonsMailSender
extends Sender {
    protected CommonsMailSender(Logger log) {
        super(log);
    }

    @Override
    public void send(Mail mail, boolean debug) throws UtilsException {
        ArrayList<File> filesAllegati = new ArrayList<File>();
        try {
            boolean attach = mail.getBody().getAttachments() != null && mail.getBody().getAttachments().size() > 0;
            Object email = null;
            email = attach ? new MultiPartEmail() : new SimpleEmail();
            email.setSocketConnectionTimeout(this.getConnectionTimeout());
            email.setSocketTimeout(this.getReadTimeout());
            email.setHostName(mail.getServerHost());
            email.setSmtpPort(mail.getServerPort());
            if (mail.getUsername() != null) {
                email.setAuthenticator((Authenticator)new DefaultAuthenticator(mail.getUsername(), mail.getPassword()));
            }
            if (mail.getSslConfig() != null) {
                email.setSSLOnConnect(true);
                StringBuffer bf = new StringBuffer();
                SSLUtilities.setSSLContextIntoJavaProperties(mail.getSslConfig(), bf);
                if (debug) {
                    this.log.debug(bf.toString());
                }
                email.setSSLCheckServerIdentity(false);
                email.setStartTLSEnabled(mail.isStartTls());
            }
            email.setFrom(mail.getFrom());
            email.addTo(mail.getTo());
            List<String> ccList = mail.getCc();
            if (ccList != null && ccList.size() > 0) {
                for (String cc : ccList) {
                    email.addCc(cc);
                }
            }
            email.setSubject(mail.getSubject());
            if (attach) {
                if (mail.getBody().getMessage() != null) {
                    email.setMsg(mail.getBody().getMessage());
                }
                for (MailAttach mailAttach : mail.getBody().getAttachments()) {
                    EmailAttachment attachment = new EmailAttachment();
                    File fTmp = null;
                    if (mailAttach instanceof MailTextAttach) {
                        MailTextAttach text = (MailTextAttach)mailAttach;
                        fTmp = File.createTempFile("mailTextAttach", ".txt");
                        FileSystemUtilities.writeFile(fTmp, text.getContent().getBytes());
                    } else {
                        MailBinaryAttach bin = (MailBinaryAttach)mailAttach;
                        fTmp = File.createTempFile("mailTextAttach", ".bin");
                        FileSystemUtilities.writeFile(fTmp, bin.getContent());
                    }
                    attachment.setPath(fTmp.getAbsolutePath());
                    filesAllegati.add(fTmp);
                    attachment.setDisposition("attachment");
                    attachment.setDescription(mailAttach.getName());
                    attachment.setName(mailAttach.getName());
                    email.attach(attachment);
                }
            } else {
                email.setMsg(mail.getBody().getMessage());
            }
            email.setDebug(debug);
            if (attach) {
                email.buildMimeMessage();
                email.sendMimeMessage();
            } else {
                email.send();
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        finally {
            for (File file : filesAllegati) {
                try {
                    file.delete();
                }
                catch (Exception exception) {}
            }
        }
    }
}

