/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.logger.log4j;

import it.link.pdd.tools.migrazione_govway.utils.logger.constants.Severity;
import org.apache.logging.log4j.Level;

public class SeverityLog4J {
    public static final Level LOG_V2_LEVEL_FATAL = Level.forName((String)SeverityLog4J.getSeverityLog4JName(Severity.FATAL), (int)99);
    public static final Level LOG_V2_LEVEL_ERROR = Level.forName((String)SeverityLog4J.getSeverityLog4JName(Severity.ERROR), (int)199);
    public static final Level LOG_V2_LEVEL_WARN = Level.forName((String)SeverityLog4J.getSeverityLog4JName(Severity.WARN), (int)299);
    public static final Level LOG_V2_LEVEL_INFO = Level.forName((String)SeverityLog4J.getSeverityLog4JName(Severity.INFO), (int)399);
    public static final Level LOG_V2_LEVEL_DEBUG_LOW = Level.forName((String)SeverityLog4J.getSeverityLog4JName(Severity.DEBUG_LOW), (int)498);
    public static final Level LOG_V2_LEVEL_DEBUG_MEDIUM = Level.forName((String)SeverityLog4J.getSeverityLog4JName(Severity.DEBUG_MEDIUM), (int)499);
    public static final Level LOG_V2_LEVEL_DEBUG_HIGH = Level.forName((String)SeverityLog4J.getSeverityLog4JName(Severity.DEBUG_HIGH), (int)599);

    private static String getSeverityLog4JName(Severity levelStr) {
        return "OP_" + levelStr.name();
    }

    public static Level getSeverityLog4J(Severity severity) {
        switch (severity) {
            case FATAL: {
                return LOG_V2_LEVEL_FATAL;
            }
            case ERROR: {
                return LOG_V2_LEVEL_ERROR;
            }
            case WARN: {
                return LOG_V2_LEVEL_WARN;
            }
            case INFO: {
                return LOG_V2_LEVEL_INFO;
            }
            case DEBUG_LOW: {
                return LOG_V2_LEVEL_DEBUG_LOW;
            }
            case DEBUG_MEDIUM: {
                return LOG_V2_LEVEL_DEBUG_MEDIUM;
            }
            case DEBUG_HIGH: {
                return LOG_V2_LEVEL_DEBUG_HIGH;
            }
        }
        return null;
    }
}

