/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.logger.log4j;

import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.logger.AbstractBasicLogger;
import it.link.pdd.tools.migrazione_govway.utils.logger.IContext;
import it.link.pdd.tools.migrazione_govway.utils.logger.beans.Attachment;
import it.link.pdd.tools.migrazione_govway.utils.logger.beans.Diagnostic;
import it.link.pdd.tools.migrazione_govway.utils.logger.beans.Event;
import it.link.pdd.tools.migrazione_govway.utils.logger.beans.Message;
import it.link.pdd.tools.migrazione_govway.utils.logger.beans.Property;
import it.link.pdd.tools.migrazione_govway.utils.logger.config.DiagnosticConfig;
import it.link.pdd.tools.migrazione_govway.utils.logger.config.Log4jConfig;
import it.link.pdd.tools.migrazione_govway.utils.logger.constants.Severity;
import it.link.pdd.tools.migrazione_govway.utils.logger.log4j.SeverityLog4J;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.slf4j.Logger;

public abstract class AbstractLog4JLogger
extends AbstractBasicLogger {
    protected Logger logTransaction;
    protected org.apache.logging.log4j.Logger logDiagnostic;
    protected Hashtable<String, org.apache.logging.log4j.Logger> mapFunctionToLogDiagnostic = null;
    protected Logger logDump;
    protected Logger logEvent;
    private static Severity diagnosticSeverity = Severity.DEBUG_HIGH;
    private static Severity eventSeverity = Severity.DEBUG_HIGH;

    public AbstractLog4JLogger(DiagnosticConfig diagnosticConfig, Log4jConfig logConfig) throws UtilsException {
        super(diagnosticConfig);
        Log4jConfig.validate(logConfig);
        Log4jConfig.setConfigurationLogger(logConfig);
        this.logTransaction = LoggerWrapperFactory.getLogger("transaction");
        if (this.logTransaction == null) {
            throw new UtilsException("Category [transaction] not found; expected in log4j configuration");
        }
        this.logDiagnostic = LoggerWrapperFactory.getLoggerImpl("diagnostic");
        if (this.logDiagnostic == null) {
            throw new UtilsException("Category [diagnostic] not found; expected in log4j configuration");
        }
        this.logDump = LoggerWrapperFactory.getLogger("dump");
        if (this.logDump == null) {
            throw new UtilsException("Category [dump] not found; expected in log4j configuration");
        }
        this.logEvent = LoggerWrapperFactory.getLogger("event");
        if (this.logEvent == null) {
            throw new UtilsException("Category [event] not found; expected in log4j configuration");
        }
    }

    private synchronized void initLogFunctionToDiagnostic() {
        if (this.mapFunctionToLogDiagnostic == null) {
            ArrayList<String> loggers = new ArrayList<String>();
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            for (String logger : context.getConfiguration().getLoggers().keySet()) {
                loggers.add(logger);
            }
            this.mapFunctionToLogDiagnostic = new Hashtable();
            Enumeration<String> functions = this.diagnosticManager.getFunctions();
            while (functions.hasMoreElements()) {
                String function = functions.nextElement();
                if (!loggers.contains("diagnostic." + function)) continue;
                this.mapFunctionToLogDiagnostic.put(function, LoggerWrapperFactory.getLoggerImpl("diagnostic." + function));
            }
        }
    }

    public static void setDiagnosticSeverity(Severity logSeverity) {
        if (logSeverity != null) {
            diagnosticSeverity = logSeverity;
        }
    }

    private static boolean emitDiagnostic(Severity severity) {
        return severity.intValue() <= diagnosticSeverity.intValue();
    }

    public static void setEventSeverity(Severity logSeverity) {
        if (logSeverity != null) {
            eventSeverity = logSeverity;
        }
    }

    private static boolean emitEvent(Severity severity) {
        return severity.intValue() <= eventSeverity.intValue();
    }

    @Override
    public void log() throws UtilsException {
        this.log(this.getContext());
    }

    @Override
    public void log(IContext contextParam) throws UtilsException {
        StringBuffer showContext = new StringBuffer();
        showContext.append("<").append(this.getContext().getIdTransaction()).append(">\n");
        this.logContext(contextParam, showContext);
        this.logTransaction.info(showContext.toString());
    }

    protected abstract void logContext(IContext var1, StringBuffer var2);

    @Override
    public void log(Event event) throws UtilsException {
        StringBuffer out = new StringBuffer();
        if (event.getSeverity() == null) {
            throw new UtilsException("Severity undefined");
        }
        if (!AbstractLog4JLogger.emitEvent(event.getSeverity())) {
            return;
        }
        if (this.getContext().getIdTransaction() != null) {
            out.append("<").append(this.getContext().getIdTransaction()).append(">");
            out.append(" \n");
        }
        if (event.getDate() != null) {
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
            out.append("Date:" + dateformat.format(event.getDate()));
            out.append(" \n");
        }
        if (event.getSeverity() != null) {
            out.append("Severity:" + event.getSeverity().name());
            out.append(" \n");
        }
        if (event.getSource() != null) {
            out.append("Source:" + event.getSource());
            out.append(" \n");
        }
        if (event.getCode() != null) {
            out.append("Code:" + event.getCode());
            out.append(" \n");
        }
        if (event.getClusterId() != null) {
            out.append("ClusterId:" + event.getClusterId());
            out.append(" \n");
        }
        if (event.getDescription() != null) {
            out.append("Description:" + event.getDescription());
            out.append(" \n");
        }
        if (event.getCorrelationIdentifier() != null) {
            out.append("CorrelationIdentifier:" + event.getCorrelationIdentifier());
            out.append(" \n");
        }
        out.append("\n");
        this.logEvent.info(out.toString());
    }

    @Override
    public String getLogParam(String logParam) throws UtilsException {
        return "DEMOValoreCallback";
    }

    protected abstract String getDomain(IContext var1);

    protected abstract String getRequestIdentifier(IContext var1);

    protected abstract String getResponseIdentifier(IContext var1);

    protected abstract String getRequestCorrelationIdentifier(IContext var1);

    protected abstract String getResponseCorrelationIdentifier(IContext var1);

    protected abstract String getClient(IContext var1);

    protected abstract String getClientPrincipal(IContext var1);

    protected abstract String getFrom(IContext var1);

    protected abstract String getTo(IContext var1);

    protected abstract String getService(IContext var1);

    protected abstract String getOperation(IContext var1);

    @Override
    protected void log(Diagnostic diagnostic, IContext context) throws UtilsException {
        if (diagnostic.getSeverity() == null) {
            throw new UtilsException("Severity undefined");
        }
        if (!AbstractLog4JLogger.emitDiagnostic(diagnostic.getSeverity())) {
            return;
        }
        StringBuffer showMsg = new StringBuffer();
        if (diagnostic.getIdTransaction() != null) {
            showMsg.append("<").append(diagnostic.getIdTransaction()).append(">");
        }
        if (diagnostic.getCode() != null) {
            if (showMsg.length() > 0) {
                showMsg.append(" ");
            }
            showMsg.append(diagnostic.getCode());
            showMsg.append(" ");
        }
        if (this.getDomain(context) != null) {
            showMsg.append(this.getDomain(context));
            showMsg.append(".");
        }
        showMsg.append(diagnostic.getFunction());
        showMsg.append(" <");
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
        showMsg.append(dateformat.format(diagnostic.getDate()));
        showMsg.append("> ");
        showMsg.append("(");
        showMsg.append(diagnostic.getSeverity().name());
        showMsg.append(")");
        String idRichiesta = this.getRequestIdentifier(context);
        String idRisposta = this.getResponseIdentifier(context);
        if (idRichiesta != null) {
            showMsg.append(" [id-req:").append(idRichiesta).append("]");
        }
        if (idRisposta != null) {
            showMsg.append(" [id-resp:").append(idRisposta).append("]");
        }
        String idCorrelazioneRichiesta = this.getRequestCorrelationIdentifier(context);
        String idCorrelazioneRisposta = this.getResponseCorrelationIdentifier(context);
        if (idCorrelazioneRichiesta != null) {
            showMsg.append(" {correlation-req:").append(idCorrelazioneRichiesta).append("}");
        }
        if (idCorrelazioneRisposta != null) {
            showMsg.append(" {correlation-resp:").append(idCorrelazioneRisposta).append("}");
        }
        String client = this.getClient(context);
        String clientPrincipal = this.getClientPrincipal(context);
        if (client != null) {
            showMsg.append(" Client:" + client);
        } else if (clientPrincipal != null) {
            showMsg.append(" Client-Principal:" + clientPrincipal);
        }
        String from = this.getFrom(context);
        String to = this.getTo(context);
        String service = this.getService(context);
        String operation = this.getOperation(context);
        if (from != null) {
            showMsg.append(" From:");
            showMsg.append(from);
        }
        if (from != null && (service != null || to != null)) {
            showMsg.append(" -> ");
        }
        if (to != null) {
            showMsg.append(" To:");
            showMsg.append(to);
        }
        if (service != null) {
            showMsg.append(" S:");
            showMsg.append(service);
        }
        if (operation != null) {
            showMsg.append(" O:");
            showMsg.append(operation);
        }
        showMsg.append("\n");
        showMsg.append(diagnostic.getMessage());
        showMsg.append("\n");
        org.apache.logging.log4j.Logger log = this.logDiagnostic;
        if (this.mapFunctionToLogDiagnostic == null) {
            this.initLogFunctionToDiagnostic();
        }
        if (this.mapFunctionToLogDiagnostic.containsKey(diagnostic.getFunction())) {
            log = this.mapFunctionToLogDiagnostic.get(diagnostic.getFunction());
        }
        log.log(this.convertToPriority(diagnostic.getSeverity()), showMsg.toString());
    }

    protected Level convertToPriority(Severity severity) {
        return SeverityLog4J.getSeverityLog4J(severity);
    }

    @Override
    public void log(Message message) throws UtilsException {
        StringBuffer out = new StringBuffer();
        if (message.getIdTransaction() != null) {
            out.append("<").append(message.getIdTransaction()).append(">");
            out.append(" \n");
        } else if (this.getContext().getIdTransaction() != null) {
            out.append("<").append(this.getContext().getIdTransaction()).append(">");
            out.append(" \n");
        }
        if (message.getType() != null) {
            out.append("Type:" + message.getType().name());
            out.append(" \n");
        }
        if (message.getContentType() != null) {
            out.append("Content-Type:" + message.getContentType());
            out.append(" \n");
        }
        if (message.getHeaders() != null && message.getHeaders().size() > 0) {
            out.append("------ Header ------\n");
            for (Property header : message.getHeadersAsList()) {
                out.append(header.getName() + "=" + header.getValue() + "\n");
            }
        }
        if (message.getResources() != null && message.getResources().size() > 0) {
            out.append("------ Resource ------\n");
            for (Property header : message.getResourcesAsList()) {
                out.append(header.getName() + "=" + header.getValue() + "\n");
            }
        }
        if (message.getContent() != null) {
            out.append("------ Content ------\n");
            out.append("Size:" + message.getContent().length + "\n");
            int max = 256000;
            String text = null;
            try {
                text = Utilities.convertToPrintableText(message.getContent(), max);
            }
            catch (Exception e) {
                text = e.getMessage();
            }
            out.append(text);
            out.append("\n");
        }
        if (message.getAttachments() != null && message.getAttachments().size() > 0) {
            for (Attachment attachment : message.getAttachments()) {
                out.append("------ Attachment id[" + attachment.getContentId() + "] ------\n");
                if (attachment.getContentType() != null) {
                    out.append("Content-Type:" + attachment.getContentType());
                    out.append(" \n");
                }
                if (attachment.getContent() == null) continue;
                out.append("Size:" + attachment.getContent().length + "\n");
                int max = 256000;
                String text = null;
                try {
                    text = Utilities.convertToPrintableText(attachment.getContent(), max);
                }
                catch (Exception e) {
                    text = e.getMessage();
                }
                out.append(text);
                out.append("\n");
            }
        }
        out.append("\n");
        this.logDump.info(out.toString());
    }
}

