/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.logger.config;

import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.logger.AbstractBaseDiagnosticManagerCore;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Properties;

public class DiagnosticConfig {
    private Boolean throwExceptionPlaceholderFailedResolution;
    private File diagnosticConfigFile;
    private String diagnosticConfigName;
    private URI diagnosticConfigURI;
    private URL diagnosticConfigURL;
    private Properties diagnosticConfigProperties;
    private static Properties staticProperties = null;

    public File getDiagnosticConfigFile() {
        return this.diagnosticConfigFile;
    }

    public void setDiagnosticConfigFile(File diagnosticConfigFile) {
        this.diagnosticConfigFile = diagnosticConfigFile;
    }

    public Properties getDiagnosticConfigProperties() {
        return this.diagnosticConfigProperties;
    }

    public void setDiagnosticConfigProperties(Properties diagnosticConfigProperties) {
        this.diagnosticConfigProperties = diagnosticConfigProperties;
    }

    public String getDiagnosticConfigName() {
        return this.diagnosticConfigName;
    }

    public void setDiagnosticConfigName(String diagnosticConfigName) {
        this.diagnosticConfigName = diagnosticConfigName;
    }

    public URI getDiagnosticConfigURI() {
        return this.diagnosticConfigURI;
    }

    public void setDiagnosticConfigURI(URI diagnosticConfigURI) {
        this.diagnosticConfigURI = diagnosticConfigURI;
    }

    public URL getDiagnosticConfigURL() {
        return this.diagnosticConfigURL;
    }

    public void setDiagnosticConfigURL(URL diagnosticConfigURL) {
        this.diagnosticConfigURL = diagnosticConfigURL;
    }

    public Boolean getThrowExceptionPlaceholderFailedResolution() {
        return this.throwExceptionPlaceholderFailedResolution;
    }

    public void setThrowExceptionPlaceholderFailedResolution(Boolean throwExceptionPlaceholderFailedResolution) {
        this.throwExceptionPlaceholderFailedResolution = throwExceptionPlaceholderFailedResolution;
    }

    public static void validate(DiagnosticConfig config) throws UtilsException {
        if (staticProperties == null) {
            DiagnosticConfig._validate(config);
        }
    }

    public static Properties readProperties(DiagnosticConfig config) throws UtilsException {
        if (staticProperties == null) {
            return DiagnosticConfig._readProperties(config);
        }
        return staticProperties;
    }

    private static void _validate(DiagnosticConfig config) throws UtilsException {
        if (staticProperties == null) {
            if (config == null) {
                throw new UtilsException("Diagnostic Configuration undefined");
            }
            if (config.getThrowExceptionPlaceholderFailedResolution() == null) {
                throw new UtilsException("Diagnostic configuration (property ThrowExceptionPlaceholderFailedResolution) undefined");
            }
            int diagnosticConfigMode = 0;
            if (config.getDiagnosticConfigFile() != null) {
                ++diagnosticConfigMode;
            }
            if (config.getDiagnosticConfigName() != null) {
                ++diagnosticConfigMode;
            }
            if (config.getDiagnosticConfigURI() != null) {
                ++diagnosticConfigMode;
            }
            if (config.getDiagnosticConfigURL() != null) {
                ++diagnosticConfigMode;
            }
            if (config.getDiagnosticConfigProperties() != null) {
                ++diagnosticConfigMode;
            }
            if (diagnosticConfigMode == 0) {
                throw new UtilsException("Diagnostic configuration uncorrect: source diagnostic configuration file undefined");
            }
            if (diagnosticConfigMode > 1) {
                throw new UtilsException("Diagnostic configuration uncorrect: found multiple source diagnostic configuration file");
            }
        }
    }

    private static synchronized Properties _readProperties(DiagnosticConfig config) throws UtilsException {
        if (staticProperties == null) {
            if (config == null) {
                throw new UtilsException("Diagnostic Configuration undefined");
            }
            Properties diagProperties = null;
            if (config.getDiagnosticConfigFile() != null) {
                diagProperties = AbstractBaseDiagnosticManagerCore.getProperties(config.getDiagnosticConfigFile());
            } else if (config.getDiagnosticConfigName() != null) {
                diagProperties = AbstractBaseDiagnosticManagerCore.getProperties(config.getDiagnosticConfigName());
            } else if (config.getDiagnosticConfigURI() != null) {
                diagProperties = AbstractBaseDiagnosticManagerCore.getProperties(config.getDiagnosticConfigURI());
            } else if (config.getDiagnosticConfigURL() != null) {
                diagProperties = AbstractBaseDiagnosticManagerCore.getProperties(config.getDiagnosticConfigURL());
            } else if (config.getDiagnosticConfigProperties() != null) {
                diagProperties = config.getDiagnosticConfigProperties();
            }
            staticProperties = diagProperties;
        }
        return staticProperties;
    }
}

