/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.logger;

import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.logger.IContext;
import it.link.pdd.tools.migrazione_govway.utils.logger.ILogger;
import java.lang.reflect.Constructor;

public class LoggerFactory {
    private static Class<ILogger> loggerImpl = null;
    private static Object[] parameters = null;
    private static Class<?>[] parameterTypes = null;

    public static void initialize(String implementationClassName, Object ... pars) throws UtilsException, ClassNotFoundException {
        Class<ILogger> c = Class.forName(implementationClassName);
        LoggerFactory.initialize(c, pars);
    }

    public static void initialize(Class<ILogger> implementationClass, Object ... pars) throws UtilsException {
        try {
            loggerImpl = implementationClass;
            parameters = pars;
            if (parameters != null) {
                parameterTypes = new Class[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    LoggerFactory.parameterTypes[i] = parameters[i].getClass();
                }
            }
        }
        catch (Exception e) {
            throw new UtilsException("Expected class assignable from " + ILogger.class.getName() + ". Found: " + implementationClass.getName() + " . Error: " + e.getMessage(), e);
        }
    }

    public static ILogger newLogger() throws UtilsException {
        return LoggerFactory.newLogger(null);
    }

    public static ILogger newLogger(IContext context) throws UtilsException {
        if (loggerImpl == null) {
            throw new UtilsException("LoggerFactory not Initialized");
        }
        try {
            Constructor<ILogger> c = loggerImpl.getConstructor(parameterTypes);
            ILogger logger = c.newInstance(parameters);
            if (context != null) {
                logger.initLogger(context);
            } else {
                logger.initLogger();
            }
            return logger;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

