/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.logger;

import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.logger.DiagnosticInfo;
import it.link.pdd.tools.migrazione_govway.utils.logger.constants.LowSeverity;
import it.link.pdd.tools.migrazione_govway.utils.logger.constants.Severity;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class DiagnosticProperties {
    private static DiagnosticProperties staticInstance;
    private static final String PREFIX_FUNCTION = "function.";
    private static final String PREFIX_DIAGNOSTIC = "diagnostic.";
    private static final String SUFFIX_DIAGNOSTIC_CODE = ".code";
    private static final String SUFFIX_DIAGNOSTIC_MESSAGE = ".message";
    private static final String SUFFIX_DIAGNOSTIC_SEVERITY = ".severity";
    private static final String DEFAULT_FUNCTION = "default.function";
    private static final String DEFAULT_SEVERITY_CODE_PREFIX = "default.severity.";
    private Properties diagnosticProperties;
    private Hashtable<String, String> mappingFunctionToCode = new Hashtable();
    private Hashtable<String, String> mappingFullCodeToFullString = new Hashtable();
    private Hashtable<String, DiagnosticInfo> mappingStringCodeToDiagnostic = new Hashtable();
    private String defaultFunction;
    private Hashtable<LowSeverity, String> mappingSeverityToCode = new Hashtable();
    private boolean throwExceptionPlaceholderFailedResolution;

    private static synchronized void initialize(Properties diagnosticProperties, boolean throwExceptionPlaceholderFailedResolution) throws UtilsException {
        if (staticInstance == null) {
            staticInstance = new DiagnosticProperties(diagnosticProperties, throwExceptionPlaceholderFailedResolution);
        }
    }

    protected static DiagnosticProperties getInstance(Properties diagnosticProperties, boolean throwExceptionPlaceholderFailedResolution) throws UtilsException {
        if (staticInstance == null) {
            DiagnosticProperties.initialize(diagnosticProperties, throwExceptionPlaceholderFailedResolution);
        }
        return staticInstance;
    }

    private DiagnosticProperties(Properties diagnosticProperties, boolean throwExceptionPlaceholderFailedResolution) throws UtilsException {
        this.diagnosticProperties = diagnosticProperties;
        this.throwExceptionPlaceholderFailedResolution = throwExceptionPlaceholderFailedResolution;
        this.init();
    }

    private DiagnosticProperties() {
    }

    public DiagnosticProperties clone() {
        Object value;
        Object key;
        Enumeration<Object> keys;
        DiagnosticProperties dmNew = new DiagnosticProperties();
        if (this.defaultFunction != null) {
            dmNew.defaultFunction = new String(this.defaultFunction);
        }
        if (this.diagnosticProperties != null && this.diagnosticProperties.size() > 0) {
            dmNew.diagnosticProperties = new Properties();
            Enumeration<Object> enKeys = this.diagnosticProperties.keys();
            while (enKeys.hasMoreElements()) {
                Object objKey = enKeys.nextElement();
                Object objValue = this.diagnosticProperties.get(objKey);
                dmNew.diagnosticProperties.put(objKey, objValue);
            }
        }
        dmNew.throwExceptionPlaceholderFailedResolution = this.throwExceptionPlaceholderFailedResolution;
        if (this.mappingFullCodeToFullString != null && this.mappingFullCodeToFullString.size() > 0) {
            dmNew.mappingFullCodeToFullString = new Hashtable();
            keys = this.mappingFullCodeToFullString.keys();
            while (keys.hasMoreElements()) {
                key = keys.nextElement();
                value = this.mappingFullCodeToFullString.get(key);
                dmNew.mappingFullCodeToFullString.put((String)key, (String)value);
            }
        }
        if (this.mappingFunctionToCode != null && this.mappingFunctionToCode.size() > 0) {
            dmNew.mappingFunctionToCode = new Hashtable();
            keys = this.mappingFunctionToCode.keys();
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                value = this.mappingFunctionToCode.get(key);
                dmNew.mappingFunctionToCode.put((String)key, (String)value);
            }
        }
        if (this.mappingSeverityToCode != null && this.mappingSeverityToCode.size() > 0) {
            dmNew.mappingSeverityToCode = new Hashtable();
            keys = this.mappingSeverityToCode.keys();
            while (keys.hasMoreElements()) {
                key = (LowSeverity)keys.nextElement();
                value = this.mappingSeverityToCode.get(key);
                dmNew.mappingSeverityToCode.put((LowSeverity)key, (String)value);
            }
        }
        if (this.mappingStringCodeToDiagnostic != null && this.mappingStringCodeToDiagnostic.size() > 0) {
            dmNew.mappingStringCodeToDiagnostic = new Hashtable();
            keys = this.mappingStringCodeToDiagnostic.keys();
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                value = this.mappingStringCodeToDiagnostic.get(key);
                dmNew.mappingStringCodeToDiagnostic.put((String)key, (DiagnosticInfo)value);
            }
        }
        return dmNew;
    }

    private void init() throws UtilsException {
        if (!this.diagnosticProperties.containsKey(DEFAULT_FUNCTION)) {
            throw new UtilsException("Property [default.function] undefined");
        }
        this.defaultFunction = this.diagnosticProperties.getProperty(DEFAULT_FUNCTION).trim();
        LowSeverity[] s = LowSeverity.values();
        for (int i = 0; i < s.length; ++i) {
            String key = DEFAULT_SEVERITY_CODE_PREFIX + s[i].name();
            if (!this.diagnosticProperties.containsKey(key)) {
                throw new UtilsException("Property [" + key + "] undefined");
            }
            this.mappingSeverityToCode.put(s[i], this.diagnosticProperties.getProperty(key).trim());
        }
        Properties functionToCodeProperties = Utilities.readProperties(PREFIX_FUNCTION, this.diagnosticProperties);
        if (functionToCodeProperties.size() <= 0) {
            throw new UtilsException("Functions undefined");
        }
        Enumeration<Object> enFunction = functionToCodeProperties.keys();
        while (enFunction.hasMoreElements()) {
            String function = (String)enFunction.nextElement();
            String code = functionToCodeProperties.getProperty(function);
            if (this.mappingFunctionToCode.containsKey(function)) {
                throw new UtilsException("Function [" + function + "] already exists");
            }
            if (function.contains(".")) {
                throw new UtilsException("Function [" + function + "] contain character '.' not permitted");
            }
            if (code == null || code.trim().equals("")) {
                throw new UtilsException("Code for function [" + function + "] undefined");
            }
            code = code.trim();
            if (this.mappingFunctionToCode.values().contains(code)) {
                throw new UtilsException("Code [" + code + "] already used for other function");
            }
            this.mappingFunctionToCode.put(function, code);
            String diagnosticForFunctionPrefix = PREFIX_DIAGNOSTIC + function + ".";
            Properties diagnosticForFunctionProperties = Utilities.readProperties(diagnosticForFunctionPrefix, this.diagnosticProperties);
            if (diagnosticForFunctionProperties.size() <= 0) {
                throw new UtilsException("Diagnostic for function [" + function + "] undefined");
            }
            Enumeration<Object> enDiagnostic = diagnosticForFunctionProperties.keys();
            while (enDiagnostic.hasMoreElements()) {
                String diagnosticTmp = (String)enDiagnostic.nextElement();
                if (!(diagnosticTmp.endsWith(SUFFIX_DIAGNOSTIC_CODE) || diagnosticTmp.endsWith(SUFFIX_DIAGNOSTIC_MESSAGE) || diagnosticTmp.endsWith(SUFFIX_DIAGNOSTIC_SEVERITY))) {
                    throw new UtilsException("Unexpected element [" + diagnosticForFunctionPrefix + diagnosticTmp + "]");
                }
                String diagnosticNameWithoutSuffix = null;
                if (diagnosticTmp.endsWith(SUFFIX_DIAGNOSTIC_CODE)) {
                    diagnosticNameWithoutSuffix = diagnosticTmp.substring(0, diagnosticTmp.length() - SUFFIX_DIAGNOSTIC_CODE.length());
                } else if (diagnosticTmp.endsWith(SUFFIX_DIAGNOSTIC_MESSAGE)) {
                    diagnosticNameWithoutSuffix = diagnosticTmp.substring(0, diagnosticTmp.length() - SUFFIX_DIAGNOSTIC_MESSAGE.length());
                } else if (diagnosticTmp.endsWith(SUFFIX_DIAGNOSTIC_SEVERITY)) {
                    diagnosticNameWithoutSuffix = diagnosticTmp.substring(0, diagnosticTmp.length() - SUFFIX_DIAGNOSTIC_SEVERITY.length());
                }
                String valueTmp = diagnosticForFunctionProperties.getProperty(diagnosticTmp);
                if (valueTmp == null || valueTmp.trim().equals("")) {
                    throw new UtilsException("Value for diagnostic [" + diagnosticForFunctionPrefix + diagnosticTmp + "] undefined");
                }
                valueTmp = valueTmp.trim();
                String fullStringCode = function + "." + diagnosticNameWithoutSuffix;
                DiagnosticInfo diagInfo = null;
                if (this.mappingStringCodeToDiagnostic.containsKey(fullStringCode)) {
                    diagInfo = this.mappingStringCodeToDiagnostic.remove(fullStringCode);
                } else {
                    diagInfo = new DiagnosticInfo();
                    diagInfo.functionCode = code;
                    diagInfo.functionString = function;
                }
                if (diagnosticTmp.endsWith(SUFFIX_DIAGNOSTIC_CODE)) {
                    if (diagInfo.code != null) {
                        throw new UtilsException("Diagnostic [" + diagnosticForFunctionPrefix + diagnosticTmp + "] already defined");
                    }
                    diagInfo.code = valueTmp;
                } else if (diagnosticTmp.endsWith(SUFFIX_DIAGNOSTIC_MESSAGE)) {
                    if (diagInfo.message != null) {
                        throw new UtilsException("Diagnostic [" + diagnosticForFunctionPrefix + diagnosticTmp + "] already defined");
                    }
                    diagInfo.message = valueTmp;
                } else if (diagnosticTmp.endsWith(SUFFIX_DIAGNOSTIC_SEVERITY)) {
                    if (diagInfo.severity != null) {
                        throw new UtilsException("Diagnostic [" + diagnosticForFunctionPrefix + diagnosticTmp + "] already defined");
                    }
                    try {
                        Severity severity;
                        diagInfo.severity = severity = Severity.valueOf(valueTmp);
                    }
                    catch (Exception e) {
                        throw new UtilsException("Value for diagnostic [" + diagnosticForFunctionPrefix + diagnosticTmp + "] is not valid, expected: " + Arrays.asList(Severity.values()));
                    }
                }
                this.mappingStringCodeToDiagnostic.put(fullStringCode, diagInfo);
            }
        }
        Enumeration<String> enStringCodes = this.mappingStringCodeToDiagnostic.keys();
        while (enStringCodes.hasMoreElements()) {
            String stringCode = enStringCodes.nextElement();
            DiagnosticInfo diagInfo = this.mappingStringCodeToDiagnostic.get(stringCode);
            if (diagInfo.code == null) {
                throw new UtilsException("Undefined code for diagnostic [diagnostic." + stringCode + "]");
            }
            if (diagInfo.message == null) {
                throw new UtilsException("Undefined message for diagnostic [diagnostic." + stringCode + "]");
            }
            if (diagInfo.severity == null) {
                throw new UtilsException("Undefined severity for diagnostic [diagnostic." + stringCode + "]");
            }
            this.mappingFullCodeToFullString.put(diagInfo.functionCode + diagInfo.code, stringCode);
        }
    }

    protected String getDefaultFunction() {
        return this.defaultFunction;
    }

    protected Hashtable<String, String> getMappingFunctionToCode() {
        return this.mappingFunctionToCode;
    }

    protected Hashtable<String, String> getMappingFullCodeToFullString() {
        return this.mappingFullCodeToFullString;
    }

    protected Hashtable<String, DiagnosticInfo> getMappingStringCodeToDiagnostic() {
        return this.mappingStringCodeToDiagnostic;
    }

    protected Hashtable<LowSeverity, String> getMappingSeverityToCode() {
        return this.mappingSeverityToCode;
    }

    protected boolean isThrowExceptionPlaceholderFailedResolution() {
        return this.throwExceptionPlaceholderFailedResolution;
    }
}

