/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.logger;

import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.date.DateManager;
import it.link.pdd.tools.migrazione_govway.utils.id.UniversallyUniqueIdentifierGenerator;
import it.link.pdd.tools.migrazione_govway.utils.logger.AbstractBaseDiagnosticManagerCore;
import it.link.pdd.tools.migrazione_govway.utils.logger.IContext;
import it.link.pdd.tools.migrazione_govway.utils.logger.ILogger;
import it.link.pdd.tools.migrazione_govway.utils.logger.beans.Diagnostic;
import it.link.pdd.tools.migrazione_govway.utils.logger.config.DiagnosticConfig;
import it.link.pdd.tools.migrazione_govway.utils.logger.constants.LowSeverity;
import it.link.pdd.tools.migrazione_govway.utils.logger.constants.Severity;

public abstract class AbstractBasicLogger
extends AbstractBaseDiagnosticManagerCore
implements ILogger {
    protected String idTransaction;

    public AbstractBasicLogger(DiagnosticConfig diagnosticConfig) throws UtilsException {
        super(diagnosticConfig);
    }

    @Override
    public void initLogger() throws UtilsException {
        try {
            UniversallyUniqueIdentifierGenerator g = new UniversallyUniqueIdentifierGenerator();
            this.idTransaction = g.newID().toString();
            super.init(this.getContext(), this);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    @Override
    public void initLogger(String idTransaction) throws UtilsException {
        try {
            if (idTransaction != null && !"".equals(idTransaction)) {
                this.idTransaction = idTransaction;
            } else {
                UniversallyUniqueIdentifierGenerator g = new UniversallyUniqueIdentifierGenerator();
                this.idTransaction = g.newID().toString();
            }
            super.init(this.getContext(), this);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    @Override
    public void log(String message, LowSeverity severity) throws UtilsException {
        String functionDefault = this.diagnosticManager.getDefaultFunction();
        this.log(functionDefault, message, severity.toSeverity(), this.diagnosticManager.getDefaultCode(functionDefault, severity));
    }

    @Override
    public void log(String message, LowSeverity severity, String function) throws UtilsException {
        this.log(function, message, severity.toSeverity(), this.diagnosticManager.getDefaultCode(function, severity));
    }

    @Override
    public void log(String code) throws UtilsException {
        this.log(this.diagnosticManager.getFunction(code), this.diagnosticManager.getMessage(code, new String[0]), this.diagnosticManager.getSeverity(code), this.diagnosticManager.getCode(code));
    }

    @Override
    public void log(String code, String ... params) throws UtilsException {
        this.log(this.diagnosticManager.getFunction(code), this.diagnosticManager.getMessage(code, params), this.diagnosticManager.getSeverity(code), this.diagnosticManager.getCode(code));
    }

    @Override
    public void log(String code, String param) throws UtilsException {
        this.log(code, new String[]{param});
    }

    @Override
    public void log(String code, Object o) throws UtilsException {
        this.log(this.diagnosticManager.getFunction(code), this.diagnosticManager.getMessage(code, o), this.diagnosticManager.getSeverity(code), this.diagnosticManager.getCode(code));
    }

    private void log(String function, String message, Severity severity, String code) throws UtilsException {
        Diagnostic diagnostic = new Diagnostic();
        diagnostic.setDate(DateManager.getDate());
        diagnostic.setCode(code);
        diagnostic.setFunction(function);
        diagnostic.setIdTransaction(this.idTransaction);
        diagnostic.setMessage(message);
        diagnostic.setSeverity(severity);
        this.log(diagnostic, this.getContext());
    }

    protected abstract void log(Diagnostic var1, IContext var2) throws UtilsException;
}

