/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.logger;

import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.date.DateManager;
import it.link.pdd.tools.migrazione_govway.utils.date.SystemDate;
import it.link.pdd.tools.migrazione_govway.utils.logger.DiagnosticManager;
import it.link.pdd.tools.migrazione_govway.utils.logger.IContext;
import it.link.pdd.tools.migrazione_govway.utils.logger.ILogger;
import it.link.pdd.tools.migrazione_govway.utils.logger.config.DiagnosticConfig;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.net.URL;
import java.util.Properties;

public abstract class AbstractBaseDiagnosticManagerCore {
    protected DiagnosticManager diagnosticManager;
    private boolean throwExceptionPlaceholderFailedResolution;
    private Properties diagnosticProperties;

    public AbstractBaseDiagnosticManagerCore(DiagnosticConfig diagnosticConfig) throws UtilsException {
        DiagnosticConfig.validate(diagnosticConfig);
        try {
            this.diagnosticProperties = DiagnosticConfig.readProperties(diagnosticConfig);
            this.throwExceptionPlaceholderFailedResolution = diagnosticConfig.getThrowExceptionPlaceholderFailedResolution();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void init(IContext context, ILogger loggerForCallback) throws UtilsException {
        try {
            DateManager.initializeDataManager(SystemDate.class.getName(), null, null);
            this.diagnosticManager = new DiagnosticManager(this.diagnosticProperties, context, this.throwExceptionPlaceholderFailedResolution, loggerForCallback);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(File file) throws UtilsException {
        String filePath = "fs";
        try {
            if (file == null) {
                throw new Exception("Resource file undefined");
            }
            filePath = file.getAbsolutePath();
            if (file.exists()) {
                Properties p = new Properties();
                FileInputStream fin = null;
                try {
                    fin = new FileInputStream(file);
                    p.load(fin);
                }
                finally {
                    try {
                        fin.close();
                    }
                    catch (Exception exception) {}
                }
                return p;
            }
            throw new UtilsException("Resource not exists");
        }
        catch (Exception e) {
            throw new UtilsException("Reading Properties failed (resource [" + filePath + "]): " + e.getMessage(), e);
        }
    }

    public static Properties getProperties(String name) throws UtilsException {
        try {
            if (name == null) {
                throw new Exception("Resource name undefined");
            }
            File f = new File(name);
            if (f.exists()) {
                return AbstractBaseDiagnosticManagerCore.getProperties(f);
            }
            Object newName = null;
            newName = name.trim().startsWith("/") ? name : "/" + name;
            URL url = AbstractBaseDiagnosticManagerCore.class.getResource((String)newName);
            if (url != null) {
                return AbstractBaseDiagnosticManagerCore.getProperties(url);
            }
            throw new UtilsException("Resource [" + name + "] not found");
        }
        catch (Exception e) {
            throw new UtilsException("Reading Properties failed (resource [" + name + "]): " + e.getMessage(), e);
        }
    }

    public static Properties getProperties(URL url) throws UtilsException {
        URI uri = null;
        try {
            if (url == null) {
                throw new Exception("Resource URL undefined");
            }
            uri = url.toURI();
        }
        catch (Exception e) {
            throw new UtilsException("Reading Properties failed (url [" + url + "]): " + e.getMessage(), e);
        }
        return AbstractBaseDiagnosticManagerCore.getProperties(uri);
    }

    public static Properties getProperties(URI uri) throws UtilsException {
        try {
            if (uri == null) {
                throw new Exception("Resource URI undefined");
            }
            File f = new File(uri);
            return AbstractBaseDiagnosticManagerCore.getProperties(f);
        }
        catch (Exception e) {
            throw new UtilsException("Reading Properties failed (uri [" + uri + "]): " + e.getMessage(), e);
        }
    }
}

