/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.jdbc;

import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.AbstractJDBCAdapter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class StreamJDBCAdapter
extends AbstractJDBCAdapter {
    protected StreamJDBCAdapter(TipiDatabase tipoDatabase) {
        super(tipoDatabase);
    }

    @Override
    public byte[] getBinaryData(ResultSet rs, int index) throws UtilsException, SQLException {
        return this.readIs(rs.getBinaryStream(index), "" + index);
    }

    @Override
    public byte[] getBinaryData(ResultSet rs, String rsName) throws UtilsException, SQLException {
        return this.readIs(rs.getBinaryStream(rsName), rsName);
    }

    @Override
    public void setBinaryData(PreparedStatement s, int index, byte[] data) throws UtilsException, SQLException {
        if (data != null && data.length > 0) {
            ByteArrayInputStream bin = null;
            try {
                bin = new ByteArrayInputStream(data);
            }
            catch (Exception e) {
                throw new UtilsException("StreamJDBCAppender error, set binary parameter [indice:" + index + "]" + e.getMessage());
            }
            s.setBinaryStream(index, (InputStream)bin, data.length);
        } else {
            s.setBinaryStream(index, (InputStream)null, 0);
        }
    }

    private byte[] readIs(InputStream is, String indice) throws UtilsException {
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream();
            byte[] readB = new byte[65536];
            int readByte = 0;
            while ((readByte = is.read(readB)) != -1) {
                os.write(readB, 0, readByte);
            }
            is.close();
            byte[] dati = os.toByteArray();
            os.close();
            return dati;
        }
        catch (Exception e) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new UtilsException("StreamJDBCAppender error, reading binary parameter [indice:" + indice + "]" + e.getMessage(), e);
        }
    }
}

