/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.jdbc;

import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.AbstractNoReturnGeneratedKeyGenerator;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.CustomKeyGeneratorObject;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.DefaultKeyGeneratorObject;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.IKeyGeneratorObject;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.KeyGeneratorException;
import java.sql.Connection;

public class PostgreSQLKeyGenerator
extends AbstractNoReturnGeneratedKeyGenerator {
    public PostgreSQLKeyGenerator(Connection connection, IKeyGeneratorObject type) throws KeyGeneratorException {
        super(connection, type);
    }

    @Override
    public String getSequenceQuery() throws KeyGeneratorException {
        Object sequence = null;
        switch (this.type.getType()) {
            case DEFAULT: {
                sequence = ((DefaultKeyGeneratorObject)this.type).getPrefix() + "_id_seq";
                break;
            }
            case CUSTOM: {
                CustomKeyGeneratorObject c = (CustomKeyGeneratorObject)this.type;
                if (c.existsCustomTableObjectsForDatabaseType(TipiDatabase.POSTGRESQL)) {
                    sequence = c.getCustomTableObjectsForDatabaseType(TipiDatabase.POSTGRESQL).getSequenceName();
                    break;
                }
                sequence = c.getDefaultTableObjects().getSequenceName();
                break;
            }
            default: {
                throw new KeyGeneratorException("Tipo di KeyGeneratorObjects non gestito: " + this.type);
            }
        }
        return "select nextval('" + (String)sequence + "'::text) as nextval";
    }
}

