/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.jdbc;

import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.DB2KeyGenerator;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.DerbyKeyGenerator;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.HyperSQLKeyGenerator;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.IKeyGenerator;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.IKeyGeneratorObject;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.KeyGeneratorException;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.MySQLKeyGenerator;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.OracleKeyGenerator;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.PostgreSQLKeyGenerator;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.SQLServerKeyGenerator;
import java.sql.Connection;

public class KeyGeneratorFactory {
    public static IKeyGenerator createKeyGeneratorFactory(String tipoDatabase, Connection connection, IKeyGeneratorObject object) throws KeyGeneratorException {
        return KeyGeneratorFactory.toKeyGenerator(tipoDatabase, connection, object);
    }

    public static IKeyGenerator toKeyGenerator(String tipoDatabase, Connection connection, IKeyGeneratorObject object) throws KeyGeneratorException {
        if (TipiDatabase.POSTGRESQL.equals(tipoDatabase)) {
            return new PostgreSQLKeyGenerator(connection, object);
        }
        if (TipiDatabase.MYSQL.equals(tipoDatabase)) {
            return new MySQLKeyGenerator(connection, object);
        }
        if (TipiDatabase.ORACLE.equals(tipoDatabase)) {
            return new OracleKeyGenerator(connection, object);
        }
        if (TipiDatabase.HSQL.equals(tipoDatabase)) {
            return new HyperSQLKeyGenerator(connection, object);
        }
        if (TipiDatabase.DERBY.equals(tipoDatabase)) {
            return new DerbyKeyGenerator(connection, object);
        }
        if (TipiDatabase.SQLSERVER.toString().equals(tipoDatabase)) {
            return new SQLServerKeyGenerator(connection, object);
        }
        if (TipiDatabase.DB2.toString().equals(tipoDatabase)) {
            return new DB2KeyGenerator(connection, object);
        }
        throw new KeyGeneratorException("Tipo database non gestito [" + tipoDatabase + "]");
    }
}

