/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.jdbc;

import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.AbstractJDBCAdapter;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.BlobJDBCAdapter;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.BytesJDBCAdapter;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.IJDBCAdapter;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.JDBCAdapterException;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.StreamJDBCAdapter;

public class JDBCAdapterFactory {
    public static IJDBCAdapter createJDBCAdapter(TipiDatabase tipoDatabase) throws JDBCAdapterException {
        AbstractJDBCAdapter jdbcAdapter = null;
        if (TipiDatabase.POSTGRESQL.equals(tipoDatabase)) {
            jdbcAdapter = new BytesJDBCAdapter(tipoDatabase);
        } else if (TipiDatabase.MYSQL.equals(tipoDatabase)) {
            jdbcAdapter = new BlobJDBCAdapter(tipoDatabase);
        } else if (TipiDatabase.ORACLE.equals(tipoDatabase)) {
            jdbcAdapter = new BlobJDBCAdapter(tipoDatabase);
        } else if (TipiDatabase.HSQL.equals(tipoDatabase)) {
            jdbcAdapter = new BytesJDBCAdapter(tipoDatabase);
        } else if (TipiDatabase.DERBY.equals(tipoDatabase)) {
            jdbcAdapter = new BytesJDBCAdapter(tipoDatabase);
        } else if (TipiDatabase.SQLSERVER.equals(tipoDatabase)) {
            jdbcAdapter = new StreamJDBCAdapter(tipoDatabase);
        } else if (TipiDatabase.DB2.equals(tipoDatabase)) {
            jdbcAdapter = new BlobJDBCAdapter(tipoDatabase);
        } else {
            throw new JDBCAdapterException("Tipo database non gestito [" + tipoDatabase + "]");
        }
        return jdbcAdapter;
    }

    public static IJDBCAdapter createJDBCAdapter(String tipoDatabase) throws JDBCAdapterException {
        return JDBCAdapterFactory.createJDBCAdapter(TipiDatabase.toEnumConstant(tipoDatabase));
    }
}

