/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.jdbc;

import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.AbstractJDBCAdapter;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BlobJDBCAdapter
extends AbstractJDBCAdapter {
    protected BlobJDBCAdapter(TipiDatabase tipoDatabase) {
        super(tipoDatabase);
    }

    @Override
    public byte[] getBinaryData(ResultSet rs, int index) throws SQLException {
        Blob aBlob = rs.getBlob(index);
        if (aBlob == null) {
            return null;
        }
        return aBlob.getBytes(1L, (int)aBlob.length());
    }

    @Override
    public byte[] getBinaryData(ResultSet rs, String rsName) throws UtilsException, SQLException {
        Blob aBlob = rs.getBlob(rsName);
        if (aBlob == null) {
            return null;
        }
        return aBlob.getBytes(1L, (int)aBlob.length());
    }

    @Override
    public InputStream getBinaryStream(ResultSet rs, int index) throws UtilsException, SQLException {
        Blob aBlob = rs.getBlob(index);
        if (aBlob == null) {
            return null;
        }
        return aBlob.getBinaryStream();
    }

    @Override
    public InputStream getBinaryStream(ResultSet rs, String rsName) throws UtilsException, SQLException {
        Blob aBlob = rs.getBlob(rsName);
        if (aBlob == null) {
            return null;
        }
        return aBlob.getBinaryStream();
    }
}

