/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.jdbc;

import it.link.pdd.tools.migrazione_govway.utils.jdbc.IKeyGenerator;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.IKeyGeneratorObject;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.KeyGeneratorException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public abstract class AbstractReturnGeneratedKeyGenerator
implements IKeyGenerator {
    protected Connection connection;
    protected IKeyGeneratorObject type;
    protected long idTraccia;

    public AbstractReturnGeneratedKeyGenerator(Connection connection, IKeyGeneratorObject type) throws KeyGeneratorException {
        this.connection = connection;
        this.type = type;
    }

    @Override
    public boolean isReturnGeneratedKeySupported() {
        return true;
    }

    @Override
    public String getColunmKeyName() throws KeyGeneratorException {
        throw new KeyGeneratorException("ReturnGeneratedKey supported");
    }

    @Override
    public long generateKey() throws KeyGeneratorException {
        throw new KeyGeneratorException("ReturnGeneratedKey supported");
    }

    @Override
    public long getReturnGeneratedKey(PreparedStatement stmt) throws KeyGeneratorException {
        ResultSet rs = null;
        try {
            rs = stmt.getGeneratedKeys();
            if (!rs.next()) {
                throw new Exception("ID autoincrementale non ottenuto via JDBC3.0");
            }
            this.idTraccia = rs.getLong(1);
            if (this.idTraccia <= 0L) {
                throw new Exception("ID autoincrementale non ottenuto: is null?");
            }
            long l = this.idTraccia;
            return l;
        }
        catch (Exception e) {
            throw new KeyGeneratorException("Errore durante la generazione della chiave via JDBC3.0: " + e.getMessage(), e);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
        }
    }
}

