/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.jdbc;

import it.link.pdd.tools.migrazione_govway.utils.jdbc.CustomKeyGeneratorObject;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.IKeyGenerator;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.IKeyGeneratorObject;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.KeyGeneratorException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public abstract class AbstractNoReturnGeneratedKeyGenerator
implements IKeyGenerator {
    protected Connection connection;
    protected IKeyGeneratorObject type;
    protected long idTable;

    public AbstractNoReturnGeneratedKeyGenerator(Connection connection, IKeyGeneratorObject type) throws KeyGeneratorException {
        this.connection = connection;
        this.type = type;
    }

    @Override
    public boolean isReturnGeneratedKeySupported() {
        return false;
    }

    @Override
    public String getColunmKeyName() throws KeyGeneratorException {
        switch (this.type.getType()) {
            case DEFAULT: {
                return "id";
            }
            case CUSTOM: {
                return ((CustomKeyGeneratorObject)this.type).getColumnNameId();
            }
        }
        throw new KeyGeneratorException("Tipo di KeyGeneratorObjects non gestito: " + this.type);
    }

    public abstract String getSequenceQuery() throws KeyGeneratorException;

    @Override
    public long generateKey() throws KeyGeneratorException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String sequenceQuery = this.getSequenceQuery();
            stmt = this.connection.prepareStatement(sequenceQuery);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new Exception("ID autoincrementale non ottenuto via Sequence");
            }
            this.idTable = rs.getLong("nextval");
            if (this.idTable <= 0L) {
                throw new Exception("ID autoincrementale non ottenuto: is null?");
            }
            long l = this.idTable;
            return l;
        }
        catch (Exception e) {
            throw new KeyGeneratorException("Errore durante la generazione della chiave: " + e.getMessage(), e);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public long getReturnGeneratedKey(PreparedStatement stmt) throws KeyGeneratorException {
        return this.idTable;
    }
}

