/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.io.notifier;

import com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType;
import com.sun.xml.messaging.saaj.packaging.mime.internet.ParseException;
import it.link.pdd.tools.migrazione_govway.utils.io.notifier.NotifierInputStreamParams;
import it.link.pdd.tools.migrazione_govway.utils.io.notifier.StreamingHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.slf4j.Logger;

public class NotifierInputStream
extends InputStream {
    private InputStream is;
    private boolean isOriginalInputStreamConsumed;
    private int currentReadPositionFromStream = 0;
    private ContentType contentType = null;
    private boolean bufferEnabled = false;
    private ByteArrayOutputStream buffer = null;
    private byte[] contentCompleteReadedFromStream = null;
    private Hashtable<String, StreamingHandler> streamingHandlers = new Hashtable();
    private List<String> streamingHandlersIds = new ArrayList<String>();
    private boolean throwStreamingHandlerException = false;
    private boolean isClosed = false;
    private Logger log = null;

    public boolean isBufferEnabled() {
        return this.bufferEnabled;
    }

    public NotifierInputStream(InputStream is, String contentType, NotifierInputStreamParams params) throws IOException, ParseException {
        if (contentType == null) {
            throw new ParseException("ContentType not defined in args");
        }
        this.contentType = new ContentType(contentType);
        if (is == null) {
            throw new ParseException("Original InputStream not defined in args");
        }
        this.is = is;
        if (params.sizeStreamingHandlers() > 0) {
            for (String streamingHandlerId : params.getStreamingHandlerIds()) {
                try {
                    this.streamingHandlers.put(streamingHandlerId, params.getStreamingHandler(streamingHandlerId));
                    this.streamingHandlersIds.add(streamingHandlerId);
                }
                catch (Exception e) {
                    throw new IOException("Streaming Handler initialization failed (id:" + streamingHandlerId + ")");
                }
            }
        }
        this.throwStreamingHandlerException = params.isThrowStreamingHandlerException();
        this.log = params.getLog();
        if (params.isBufferEnabled()) {
            this.setONBuffering();
        }
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.read_engine(b, off, len, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read_engine(byte[] b, int off, int len, boolean incrementCurrentReadPositionFromStream) throws IOException {
        int readBytes = 0;
        int offset = off;
        try {
            if (this.isOriginalInputStreamConsumed) {
                if (this.contentCompleteReadedFromStream != null) {
                    if (this.currentReadPositionFromStream >= this.contentCompleteReadedFromStream.length) {
                        int n = -1;
                        return n;
                    }
                    int position = this.currentReadPositionFromStream;
                    while (position < this.contentCompleteReadedFromStream.length && readBytes < len) {
                        if (offset >= b.length) {
                            throw new IndexOutOfBoundsException("Offset: " + offset + " , byte[] length: " + b.length);
                        }
                        b[offset] = this.contentCompleteReadedFromStream[position];
                        ++readBytes;
                        ++offset;
                    }
                    int n = readBytes;
                    return n;
                }
                int n = -1;
                return n;
            }
            readBytes = this.performReadBytes(b, off, len);
            if (readBytes == -1) {
                this.isOriginalInputStreamConsumed = true;
            }
            if (this.bufferEnabled) {
                if (this.isOriginalInputStreamConsumed) {
                    this.finalizeBuffer();
                } else {
                    this.buffer.write(b, offset, readBytes);
                }
            }
            int n = readBytes;
            return n;
        }
        finally {
            if (incrementCurrentReadPositionFromStream) {
                this.currentReadPositionFromStream += readBytes;
            }
        }
    }

    private int performReadBytes(byte[] b, int off, int len) throws IOException {
        int readBytes = 0;
        readBytes = this.is == null ? -1 : this.is.read(b, off, len);
        ByteArrayOutputStream bout = null;
        for (String streamingHandlerId : this.streamingHandlersIds) {
            StreamingHandler streamingHandler = this.streamingHandlers.get(streamingHandlerId);
            try {
                if (readBytes == -1) {
                    streamingHandler.end();
                    continue;
                }
                if (bout == null) {
                    bout = new ByteArrayOutputStream();
                    bout.write(b, off, readBytes);
                    bout.flush();
                    bout.close();
                }
                streamingHandler.feed(bout.toByteArray());
            }
            catch (Throwable e) {
                if (this.log != null) {
                    this.log.error("[" + streamingHandlerId + "] error occurs: " + e.getMessage(), e);
                }
                if (!this.throwStreamingHandlerException) continue;
                throw new IOException("[" + streamingHandlerId + "] " + e.getMessage());
            }
        }
        return readBytes;
    }

    @Override
    public int read() throws IOException {
        return this.read_engine(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read_engine(boolean incrementCurrentReadPositionFromStream) throws IOException {
        try {
            if (this.isOriginalInputStreamConsumed) {
                if (this.contentCompleteReadedFromStream != null) {
                    if (this.currentReadPositionFromStream >= this.contentCompleteReadedFromStream.length) {
                        int n = -1;
                        return n;
                    }
                    byte by = this.contentCompleteReadedFromStream[this.currentReadPositionFromStream];
                    return by;
                }
                int n = -1;
                return n;
            }
            int byteRead = this.performRead();
            if (byteRead == -1) {
                this.isOriginalInputStreamConsumed = true;
            }
            if (this.bufferEnabled) {
                if (this.isOriginalInputStreamConsumed) {
                    this.finalizeBuffer();
                } else {
                    this.buffer.write(byteRead);
                }
            }
            int n = byteRead;
            return n;
        }
        finally {
            if (incrementCurrentReadPositionFromStream) {
                ++this.currentReadPositionFromStream;
            }
        }
    }

    private int performRead() throws IOException {
        int b = this.is.read();
        for (String streamingHandlerId : this.streamingHandlersIds) {
            StreamingHandler streamingHandler = this.streamingHandlers.get(streamingHandlerId);
            try {
                if (b == -1) {
                    streamingHandler.end();
                    continue;
                }
                streamingHandler.feed((byte)b);
            }
            catch (Throwable e) {
                if (this.log != null) {
                    this.log.error("[" + streamingHandlerId + "] error occurs: " + e.getMessage(), e);
                }
                if (!this.throwStreamingHandlerException) continue;
                throw new IOException("[" + streamingHandlerId + "] " + e.getMessage());
            }
        }
        return b;
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            if (this.is != null) {
                this.is.close();
            }
            IOException streamingHandlerException = null;
            for (String streamingHandlerId : this.streamingHandlersIds) {
                StreamingHandler streamingHandler = this.streamingHandlers.get(streamingHandlerId);
                try {
                    streamingHandler.closeResources();
                }
                catch (Throwable e) {
                    if (this.log != null) {
                        this.log.error("[" + streamingHandlerId + "] error occurs: " + e.getMessage(), e);
                    }
                    if (!this.throwStreamingHandlerException || streamingHandlerException != null) continue;
                    streamingHandlerException = new IOException("[" + streamingHandlerId + "] " + e.getMessage());
                }
            }
            this.isClosed = true;
            if (streamingHandlerException != null) {
                throw streamingHandlerException;
            }
        }
    }

    public void addStreamingHandler(StreamingHandler handler) throws IOException {
        if (this.currentReadPositionFromStream > 0) {
            if (!this.bufferEnabled) {
                throw new IOException("You can not add handler after the stream has been accessed with buffering disabled");
            }
            String id = handler.getID();
            if (this.streamingHandlersIds.contains(id)) {
                throw new IOException("StreamingHandler with id [" + id + "] already exists");
            }
            this.streamingHandlers.put(id, handler);
            this.streamingHandlersIds.add(id);
            if (this.isOriginalInputStreamConsumed) {
                handler.feed(this.contentCompleteReadedFromStream);
                handler.end();
            } else {
                handler.feed(this.buffer.toByteArray());
            }
        }
    }

    public <T extends StreamingHandler> T getFirstStreamingHandlerByType(Class<T> clazz) throws IOException {
        for (String streamingHandlerId : this.streamingHandlersIds) {
            StreamingHandler streamingHandler = this.streamingHandlers.get(streamingHandlerId);
            if (!streamingHandler.getClass().equals(clazz)) continue;
            return (T)streamingHandler;
        }
        throw new IOException("StreamingHandler with type [" + clazz.getName() + "] not exists");
    }

    public StreamingHandler getStreamingHandler(String id) throws IOException {
        if (this.streamingHandlersIds.contains(id)) {
            return this.streamingHandlers.get(id);
        }
        throw new IOException("StreamingHandler with id [" + id + "] not exists");
    }

    public void setONBuffering() throws IOException {
        if (this.currentReadPositionFromStream > 0) {
            throw new IOException("You can not enable buffering after the stream has been accessed");
        }
        if (this.bufferEnabled) {
            throw new IOException("The buffering is already enabled");
        }
        this.bufferEnabled = true;
        this.buffer = new ByteArrayOutputStream();
    }

    public void setOFFBuffering() throws IOException {
        this.setOFFBuffering(true);
    }

    public void setOFFBuffering(boolean releaseBufferReaded) throws IOException {
        if (!this.bufferEnabled) {
            throw new IOException("The buffering is not enabled");
        }
        this.bufferEnabled = false;
        if (releaseBufferReaded) {
            this.contentCompleteReadedFromStream = null;
            if (this.buffer != null) {
                this.buffer.close();
                this.buffer = null;
            }
        }
    }

    private void finalizeBuffer() throws IOException {
        if (!this.bufferEnabled) {
            throw new IOException("BufferMode is not enabled");
        }
        if (this.contentCompleteReadedFromStream != null) {
            throw new IOException("bufferingComplete already invoked");
        }
        this.buffer.flush();
        this.buffer.close();
        this.contentCompleteReadedFromStream = this.buffer.toByteArray();
        this.buffer = null;
    }

    public void serialize(OutputStream out) throws IOException {
        this.serializeEngine(out, false);
    }

    public void serializeAndConsume(OutputStream out) throws IOException {
        this.serializeEngine(out, true);
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.serializeEngine(bout, false);
        bout.flush();
        bout.close();
        return bout.toByteArray();
    }

    public byte[] serializeAndConsume() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.serializeEngine(bout, true);
        bout.flush();
        bout.close();
        return bout.toByteArray();
    }

    private void serializeEngine(OutputStream out, boolean consume) throws IOException {
        if (this.contentCompleteReadedFromStream != null) {
            out.write(this.contentCompleteReadedFromStream);
            return;
        }
        if (this.buffer != null) {
            this.buffer.flush();
            if (this.buffer.size() > 0) {
                out.write(this.buffer.toByteArray());
            }
        }
        if (consume) {
            if (this.bufferEnabled) {
                this.setOFFBuffering();
            } else if (this.buffer != null) {
                this.buffer.close();
                this.buffer = null;
            }
        }
        byte[] buffer = new byte[1024];
        int byteRead = this.read_engine(buffer, 0, buffer.length, false);
        while (byteRead != -1) {
            out.write(buffer, 0, byteRead);
            byteRead = this.read_engine(buffer, 0, buffer.length, false);
        }
    }
}

