/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.io;

import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarUtilities {
    public static boolean isJar(File file, boolean checkExtension) {
        try {
            JarFile jar = JarUtilities.getJar(file, checkExtension);
            return jar != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static JarFile getJar(File file, boolean checkExtension) throws UtilsException {
        try {
            if (checkExtension && !file.getName().endsWith(".jar")) {
                throw new Exception("Estensione del file diversa da quella attesa");
            }
            JarURLConnection conn = JarUtilities.getConnection(file, null);
            return conn.getJarFile();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static Manifest getManifest(File file) throws UtilsException {
        try {
            JarURLConnection conn = JarUtilities.getConnection(file, null);
            return conn.getManifest();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static byte[] getEntry(File jarFile, String jarEntry) throws UtilsException {
        byte[] byArray;
        InputStream is = null;
        try {
            byte[] buffer;
            JarURLConnection conn = JarUtilities.getConnection(jarFile, jarEntry);
            JarFile jar = conn.getJarFile();
            JarEntry entry = conn.getJarEntry();
            if (entry == null) {
                byte[] byArray2 = null;
                return byArray2;
            }
            is = jar.getInputStream(entry);
            byArray = buffer = Utilities.getAsByteArray(is);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        return byArray;
    }

    private static JarURLConnection getConnection(File jarFile, String jarEntry) throws MalformedURLException, IOException {
        URL archivio = new URL("file://" + jarFile.getCanonicalPath());
        String url = "jar:" + archivio.toExternalForm() + "!/";
        if (jarEntry != null) {
            url = url + jarEntry;
        }
        archivio = new URL(url);
        return (JarURLConnection)archivio.openConnection();
    }
}

