/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.id.serial;

import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.date.DateManager;
import it.link.pdd.tools.migrazione_govway.utils.id.serial.IDSerialGeneratorBuffer;
import it.link.pdd.tools.migrazione_govway.utils.id.serial.IDSerialGeneratorParameter;
import it.link.pdd.tools.migrazione_govway.utils.id.serial.InfoStatistics;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.JDBCUtilities;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLObjectFactory;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Random;
import org.slf4j.Logger;

public class IDSerialGenerator_numeric {
    public static String generate(Connection conDB, TipiDatabase tipoDatabase, IDSerialGeneratorParameter param, Logger log, InfoStatistics infoStatistics) throws UtilsException {
        Object msgError;
        String columnProtocollo;
        String columnPrg;
        String columnInfoAssociata;
        long attesaAttivaJDBC = param.getSerializableTimeWaitMs();
        int checkIntervalloJDBC = param.getSerializableNextIntervalTimeMs();
        String protocollo = param.getProtocollo();
        long counterTmp = -1L;
        boolean idBuildOK = false;
        long scadenzaWhile = DateManager.getTimeMillis() + attesaAttivaJDBC;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        int iteration = 0;
        ArrayList<String> messageException = new ArrayList<String>();
        String table = param.getTableName();
        if (table == null) {
            table = param.getInformazioneAssociataAlProgressivo() != null ? "ID_MESSAGGIO_RELATIVO" : "ID_MESSAGGIO";
        }
        if ((columnInfoAssociata = param.getColumnRelativeInfo()) == null) {
            columnInfoAssociata = "INFO_ASSOCIATA";
        }
        if ((columnPrg = param.getColumnPrg()) == null) {
            columnPrg = "COUNTER";
        }
        if ((columnProtocollo = param.getColumnProtocol()) == null) {
            columnProtocollo = "PROTOCOLLO";
        }
        boolean maxValueAndWrapDisabled = false;
        ArrayList<String> valuesGenerated = new ArrayList<String>();
        boolean rowNotExistsAndSerializableLevelNotFound = false;
        while (!(maxValueAndWrapDisabled || rowNotExistsAndSerializableLevelNotFound || idBuildOK || DateManager.getTimeMillis() >= scadenzaWhile)) {
            String valueFromBuffer;
            valuesGenerated = new ArrayList();
            ++iteration;
            if (param.getSizeBuffer() > 1 && (valueFromBuffer = IDSerialGeneratorBuffer.nextValue(IDSerialGenerator_numeric.class, param.getInformazioneAssociataAlProgressivo())) != null) {
                return valueFromBuffer;
            }
            counterTmp = -1L;
            Statement pstmt = null;
            Statement pstmtInsert = null;
            ResultSet rs = null;
            try {
                ISQLQueryObject sqlGet = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
                sqlGet.addSelectField(columnPrg);
                sqlGet.addFromTable(table);
                sqlGet.setANDLogicOperator(true);
                sqlGet.addWhereCondition(columnProtocollo + "=?");
                if (param.getInformazioneAssociataAlProgressivo() != null) {
                    sqlGet.addWhereCondition(columnInfoAssociata + "=?");
                }
                sqlGet.setSelectForUpdate(true);
                StringBuffer query = new StringBuffer();
                query.append(sqlGet.createSQLQuery());
                pstmt = conDB.prepareStatement(query.toString());
                pstmt.setString(1, protocollo);
                if (param.getInformazioneAssociataAlProgressivo() != null) {
                    pstmt.setString(2, param.getInformazioneAssociataAlProgressivo());
                }
                if ((rs = pstmt.executeQuery()) == null) {
                    pstmt.close();
                    log.error("Creazione serial non riuscita: ResultSet is null?");
                    throw new UtilsException("Creazione serial non riuscita: ResultSet is null?");
                }
                boolean exist = rs.next();
                if (!exist && !JDBCUtilities.isTransactionIsolationSerializable(conDB.getTransactionIsolation(), tipoDatabase)) {
                    rowNotExistsAndSerializableLevelNotFound = true;
                    continue;
                }
                if (exist) {
                    counterTmp = rs.getLong(columnPrg);
                    for (int i = 0; i < param.getSizeBuffer(); ++i) {
                        if (counterTmp + 1L > param.getMaxValue()) {
                            if (param.isWrap()) {
                                counterTmp = 0L;
                            } else {
                                if (valuesGenerated.size() > 0) break;
                                maxValueAndWrapDisabled = true;
                                throw new Exception("Max Value of identifier has been reached");
                            }
                        }
                        valuesGenerated.add("" + ++counterTmp);
                    }
                }
                rs.close();
                pstmt.close();
                if (!exist) {
                    counterTmp = 1L;
                    StringBuffer queryInsert = new StringBuffer();
                    ISQLQueryObject sqlInsert = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
                    sqlInsert.addInsertTable(table);
                    sqlInsert.addInsertField(columnPrg, "?");
                    sqlInsert.addInsertField(columnProtocollo, "?");
                    if (param.getInformazioneAssociataAlProgressivo() != null) {
                        sqlInsert.addInsertField(columnInfoAssociata, "?");
                    }
                    queryInsert.append(sqlInsert.createSQLInsert());
                    pstmtInsert = conDB.prepareStatement(queryInsert.toString());
                    pstmtInsert.setLong(1, 1L);
                    pstmtInsert.setString(2, protocollo);
                    if (param.getInformazioneAssociataAlProgressivo() != null) {
                        pstmtInsert.setString(3, param.getInformazioneAssociataAlProgressivo());
                    }
                    pstmtInsert.execute();
                    pstmtInsert.close();
                    valuesGenerated.add("" + counterTmp);
                } else {
                    StringBuffer queryUpdate = new StringBuffer();
                    ISQLQueryObject sqlUpdate = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
                    sqlUpdate.addUpdateTable(table);
                    sqlUpdate.addUpdateField(columnPrg, "?");
                    sqlUpdate.setANDLogicOperator(true);
                    sqlUpdate.addWhereCondition(columnProtocollo + "=?");
                    if (param.getInformazioneAssociataAlProgressivo() != null) {
                        sqlUpdate.addWhereCondition(columnInfoAssociata + "=?");
                    }
                    queryUpdate.append(sqlUpdate.createSQLUpdate());
                    pstmtInsert = conDB.prepareStatement(queryUpdate.toString());
                    pstmtInsert.setLong(1, counterTmp);
                    pstmtInsert.setString(2, protocollo);
                    if (param.getInformazioneAssociataAlProgressivo() != null) {
                        pstmtInsert.setString(3, param.getInformazioneAssociataAlProgressivo());
                    }
                    pstmtInsert.execute();
                    pstmtInsert.close();
                }
                conDB.commit();
                idBuildOK = true;
            }
            catch (Throwable e) {
                ps.append("********* Exception Iteration [" + iteration + "] **********\n");
                String msg = e.getMessage();
                if (msg == null) {
                    msg = "NULL-MESSAGE";
                }
                if (messageException.contains(msg)) {
                    ps.append("Message already occurs: " + msg);
                } else {
                    e.printStackTrace(ps);
                    messageException.add(msg);
                }
                ps.append("\n\n");
                if (infoStatistics != null) {
                    infoStatistics.addErrorSerializableAccess(e);
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmtInsert != null) {
                        pstmtInsert.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    conDB.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (idBuildOK) continue;
            try {
                int intervalloDestro = checkIntervalloJDBC;
                if (param.isSerializableNextIntervalTimeMsIncrementMode() && (intervalloDestro += iteration * param.getSerializableNextIntervalTimeMsIncrement()) > param.getMaxSerializableNextIntervalTimeMs()) {
                    intervalloDestro = param.getMaxSerializableNextIntervalTimeMs();
                }
                int sleep = new Random().nextInt(intervalloDestro);
                Utilities.sleep(sleep);
            }
            catch (Exception exception) {}
        }
        try {
            if (ps != null) {
                ps.flush();
            }
        }
        catch (Exception pstmt) {
            // empty catch block
        }
        try {
            if (out != null) {
                out.flush();
            }
        }
        catch (Exception pstmt) {
            // empty catch block
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (Exception pstmt) {
            // empty catch block
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception pstmt) {
            // empty catch block
        }
        if (maxValueAndWrapDisabled) {
            msgError = "Max Value [" + param.getMaxValue() + "] of identifier has been reached";
            log.error((String)msgError + ": " + out.toString());
            throw new UtilsException((String)msgError);
        }
        if (rowNotExistsAndSerializableLevelNotFound) {
            msgError = "Raw not exists and serializable level is disabled";
            log.error((String)msgError);
            throw new UtilsException((String)msgError);
        }
        if (!idBuildOK || counterTmp <= 0L) {
            msgError = "Creazione serial non riuscita: l'accesso serializable non ha permesso la creazione del numero sequenziale";
            log.error((String)msgError + ": " + out.toString());
            throw new UtilsException((String)msgError);
        }
        String vRet = (String)valuesGenerated.remove(0);
        if (valuesGenerated.size() > 0) {
            IDSerialGeneratorBuffer.putAll(valuesGenerated, IDSerialGenerator_numeric.class, param.getInformazioneAssociataAlProgressivo());
        }
        return vRet;
    }
}

