/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.id.serial;

import it.link.pdd.tools.migrazione_govway.utils.id.serial.IDSerialGenerator_alphanumeric;
import it.link.pdd.tools.migrazione_govway.utils.id.serial.IDSerialGenerator_numeric;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class IDSerialGeneratorBuffer {
    private static Hashtable<String, List<String>> buffer = new Hashtable();

    private static String getPrefix(Class<?> cIdSerialGenerator) {
        if (IDSerialGenerator_alphanumeric.class.getName().equals(cIdSerialGenerator.getName())) {
            return "A_";
        }
        if (IDSerialGenerator_numeric.class.getName().equals(cIdSerialGenerator.getName())) {
            return "N_";
        }
        return "U_";
    }

    private static String getKey(Class<?> cIdSerialGenerator, String relativeInfo) {
        StringBuffer bf = new StringBuffer();
        bf.append(IDSerialGeneratorBuffer.getPrefix(cIdSerialGenerator));
        if (relativeInfo != null) {
            bf.append(relativeInfo);
        } else {
            bf.append("@_NONRELATIVE_@");
        }
        return bf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String nextValue(Class<?> cIdSerialGenerator, String relativeInfo) {
        String key = IDSerialGeneratorBuffer.getKey(cIdSerialGenerator, relativeInfo);
        Hashtable<String, List<String>> hashtable = buffer;
        synchronized (hashtable) {
            if (buffer.size() <= 0 || !buffer.containsKey(key)) {
                return null;
            }
            List<String> l = buffer.get(key);
            if (l == null || l.size() <= 0) {
                return null;
            }
            if (l.size() == 1) {
                l = buffer.remove(key);
            }
            String v = l.remove(0);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void putAll(List<String> valuesGenerated, Class<?> cIdSerialGenerator, String relativeInfo) {
        String key = IDSerialGeneratorBuffer.getKey(cIdSerialGenerator, relativeInfo);
        Hashtable<String, List<String>> hashtable = buffer;
        synchronized (hashtable) {
            List<Object> l = null;
            if (buffer.containsKey(key)) {
                l = buffer.get(key);
            } else {
                l = new ArrayList();
                buffer.put(key, l);
            }
            l.addAll(valuesGenerated);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void clearBuffer() {
        Hashtable<String, List<String>> hashtable = buffer;
        synchronized (hashtable) {
            if (buffer != null && buffer.size() > 0) {
                buffer.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void clearBuffer(Class<?> cIdSerialGenerator) {
        String prefix = IDSerialGeneratorBuffer.getPrefix(cIdSerialGenerator);
        Hashtable<String, List<String>> hashtable = buffer;
        synchronized (hashtable) {
            if (buffer != null && buffer.size() > 0) {
                Enumeration<String> keys = buffer.keys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    if (!key.startsWith(prefix)) continue;
                    buffer.remove(key);
                }
            }
        }
    }
}

