/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.id.serial;

import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.id.serial.IDSerialGeneratorBuffer;
import it.link.pdd.tools.migrazione_govway.utils.id.serial.IDSerialGeneratorParameter;
import it.link.pdd.tools.migrazione_govway.utils.id.serial.IDSerialGeneratorType;
import it.link.pdd.tools.migrazione_govway.utils.id.serial.IDSerialGenerator_alphanumeric;
import it.link.pdd.tools.migrazione_govway.utils.id.serial.IDSerialGenerator_mysql;
import it.link.pdd.tools.migrazione_govway.utils.id.serial.IDSerialGenerator_numeric;
import it.link.pdd.tools.migrazione_govway.utils.id.serial.InfoStatistics;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.JDBCUtilities;
import java.sql.Connection;
import org.slf4j.Logger;

public class IDSerialGenerator {
    private InfoStatistics infoStatistics;

    public IDSerialGenerator(InfoStatistics infoStatistics) {
        this.infoStatistics = infoStatistics;
    }

    public IDSerialGenerator() {
    }

    public void clearBuffer() {
        IDSerialGeneratorBuffer.clearBuffer();
    }

    public void clearBuffer(IDSerialGeneratorParameter param) {
        IDSerialGeneratorType tipo = param.getTipo();
        if (IDSerialGeneratorType.ALFANUMERICO.equals((Object)tipo) || IDSerialGeneratorType.NUMERIC.equals((Object)tipo) || IDSerialGeneratorType.DEFAULT.equals((Object)tipo)) {
            if (IDSerialGeneratorType.NUMERIC.equals((Object)tipo) || IDSerialGeneratorType.DEFAULT.equals((Object)tipo)) {
                IDSerialGeneratorBuffer.clearBuffer(IDSerialGenerator_numeric.class);
            } else {
                IDSerialGeneratorBuffer.clearBuffer(IDSerialGenerator_alphanumeric.class);
            }
        }
    }

    public long buildIDAsNumber(IDSerialGeneratorParameter param, Connection con, TipiDatabase tipoDatabase, Logger log) throws UtilsException {
        try {
            if (IDSerialGeneratorType.ALFANUMERICO.equals(param)) {
                throw new UtilsException("IDSerialGeneratorType[" + param.getTipo() + "] prevede anche caratteri alfanumerici");
            }
            return Long.parseLong(this.buildID(param, con, tipoDatabase, log));
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String buildID(IDSerialGeneratorParameter param, Connection con, TipiDatabase tipoDatabase, Logger log) throws UtilsException {
        IDSerialGeneratorType tipo = param.getTipo();
        if (con == null) {
            throw new UtilsException("Connessione non fornita");
        }
        try {
            if (con.isClosed()) {
                throw new UtilsException("Connessione risulta gi\u00e0 chiusa");
            }
        }
        catch (Exception e) {
            throw new UtilsException("Test Connessione non riuscito: " + e.getMessage(), e);
        }
        boolean originalConnectionAutocommit = false;
        boolean autoCommitModificato = false;
        try {
            originalConnectionAutocommit = con.getAutoCommit();
        }
        catch (Exception e) {
            throw new UtilsException("Verifica AutoCommit Connessione non riuscito: " + e.getMessage(), e);
        }
        if (!originalConnectionAutocommit) {
            throw new UtilsException("Creazione serial [" + tipo.name() + "] non riuscita (Non e' possibile fornire una connessione con autocommit disabilitato poiche' l'utility ha necessita' di effettuare operazioni di commit/rollback)");
        }
        int originalConnectionTransactionIsolation = -1;
        boolean transactionIsolationModificato = false;
        try {
            originalConnectionTransactionIsolation = con.getTransactionIsolation();
        }
        catch (Exception e) {
            throw new UtilsException("Lettura livello di isolamento transazione della Connessione non riuscito: " + e.getMessage(), e);
        }
        String identificativoUnivoco = null;
        try {
            if (IDSerialGeneratorType.MYSQL.equals((Object)tipo)) {
                identificativoUnivoco = IDSerialGenerator_mysql.generate(con, param, log, this.infoStatistics);
            } else if (IDSerialGeneratorType.ALFANUMERICO.equals((Object)tipo) || IDSerialGeneratorType.NUMERIC.equals((Object)tipo) || IDSerialGeneratorType.DEFAULT.equals((Object)tipo)) {
                try {
                    try {
                        con.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (param.isSerializableLevel()) {
                        JDBCUtilities.setTransactionIsolationSerializable(tipoDatabase, con);
                        transactionIsolationModificato = true;
                    }
                    if (originalConnectionAutocommit) {
                        con.setAutoCommit(false);
                        autoCommitModificato = true;
                    }
                }
                catch (Exception er) {
                    log.error("Creazione serial non riuscita (impostazione transazione): " + er.getMessage(), (Throwable)er);
                    throw new UtilsException("Creazione serial non riuscita (impostazione transazione): " + er.getMessage(), er);
                }
                identificativoUnivoco = IDSerialGeneratorType.NUMERIC.equals((Object)tipo) || IDSerialGeneratorType.DEFAULT.equals((Object)tipo) ? IDSerialGenerator_numeric.generate(con, tipoDatabase, param, log, this.infoStatistics) : IDSerialGenerator_alphanumeric.generate(con, tipoDatabase, param, log, this.infoStatistics);
            } else {
                throw new UtilsException("Tipo di generazione [" + tipo + "] non supportata");
            }
            String string = identificativoUnivoco;
            return string;
        }
        finally {
            try {
                if (transactionIsolationModificato) {
                    con.setTransactionIsolation(originalConnectionTransactionIsolation);
                }
                if (autoCommitModificato) {
                    con.setAutoCommit(originalConnectionAutocommit);
                }
            }
            catch (Exception er) {
                log.error("Creazione serial non riuscita (ripristino transazione): " + er.getMessage());
                throw new UtilsException("Creazione serial non riuscita (ripristino transazione): " + er.getMessage());
            }
        }
    }
}

