/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.id.apache.serial;

import it.link.pdd.tools.migrazione_govway.utils.id.apache.AbstractStringIdentifierGenerator;
import it.link.pdd.tools.migrazione_govway.utils.id.apache.serial.MaxReachedException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;

public class TimeBasedAlphanumericIdentifierGenerator
extends AbstractStringIdentifierGenerator
implements Serializable {
    private static final long serialVersionUID = 20060116L;
    private static final char[] padding = new char[MAX_LONG_ALPHANUMERIC_VALUE_LENGTH];
    private static final TimeZone UTC;
    private static long last;
    private static long counter;
    private final int postfixSize;
    private final long offset;

    public TimeBasedAlphanumericIdentifierGenerator(int postfixSize, long offset) {
        if (postfixSize < 0 || postfixSize > MAX_LONG_ALPHANUMERIC_VALUE_LENGTH) {
            throw new IllegalArgumentException("Invalid size for postfix");
        }
        this.postfixSize = postfixSize;
        this.offset = offset;
    }

    public TimeBasedAlphanumericIdentifierGenerator(int postfixSize) {
        this(postfixSize, 0L);
    }

    public TimeBasedAlphanumericIdentifierGenerator() {
        this(3);
    }

    @Override
    public long maxLength() {
        return MAX_LONG_ALPHANUMERIC_VALUE_LENGTH + this.postfixSize;
    }

    @Override
    public long minLength() {
        return this.maxLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String nextStringIdentifier() throws MaxReachedException {
        String postfix;
        long now;
        TimeBasedAlphanumericIdentifierGenerator timeBasedAlphanumericIdentifierGenerator = this;
        synchronized (timeBasedAlphanumericIdentifierGenerator) {
            now = Calendar.getInstance(UTC).getTime().getTime();
            long diff = now - last;
            if (diff > 0L || diff < -1000L) {
                last = now;
                counter = 0L;
            } else {
                if (diff != 0L) {
                    now = last;
                }
                ++counter;
            }
        }
        String string = postfix = counter > 0L ? Long.toString(counter, 36) : "";
        if (postfix.length() > this.postfixSize) {
            throw new MaxReachedException("The maximum number of identifiers in this millisecond has been reached");
        }
        long base = now - this.offset;
        long value = base < 0L ? base + Long.MAX_VALUE + 1L : base;
        String time = Long.toString(value, 36);
        char[] buffer = new char[MAX_LONG_ALPHANUMERIC_VALUE_LENGTH + this.postfixSize];
        int i = 0;
        int maxPad = MAX_LONG_ALPHANUMERIC_VALUE_LENGTH - time.length();
        if (maxPad > 0) {
            System.arraycopy(padding, 0, buffer, 0, maxPad);
        }
        System.arraycopy(time.toCharArray(), 0, buffer, maxPad, time.length());
        if (base < 0L) {
            buffer[0] = (char)(buffer[0] + 2);
        }
        i += time.length() + maxPad;
        if (this.postfixSize > 0) {
            maxPad = this.postfixSize - postfix.length();
            if (maxPad > 0) {
                System.arraycopy(padding, 0, buffer, i, maxPad);
                i += maxPad;
            }
            System.arraycopy(postfix.toCharArray(), 0, buffer, i, postfix.length());
        }
        return new String(buffer);
    }

    public long getMillisecondsFromId(Object id, long offset) {
        if (id instanceof String && id.toString().length() >= MAX_LONG_ALPHANUMERIC_VALUE_LENGTH) {
            boolean overflow;
            char[] buffer = new char[MAX_LONG_ALPHANUMERIC_VALUE_LENGTH];
            System.arraycopy(id.toString().toCharArray(), 0, buffer, 0, MAX_LONG_ALPHANUMERIC_VALUE_LENGTH);
            boolean bl = overflow = buffer[0] > '1';
            if (overflow) {
                buffer[0] = (char)(buffer[0] - 2);
            }
            long value = Long.parseLong(new String(buffer), 36);
            if (overflow) {
                value -= Long.MIN_VALUE;
            }
            return value + offset;
        }
        throw new IllegalArgumentException("'" + id + "' is not an id from this generator");
    }

    static {
        Arrays.fill(padding, '0');
        UTC = TimeZone.getTimeZone("UTC");
        last = 0L;
        counter = 0L;
    }
}

