/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.id.apache.serial;

import it.link.pdd.tools.migrazione_govway.utils.id.apache.serial.AlphanumericGenerator;
import it.link.pdd.tools.migrazione_govway.utils.id.apache.serial.MaxReachedException;

public class PrefixedAlphanumericGenerator
extends AlphanumericGenerator {
    private static final long serialVersionUID = 1L;
    private final String prefix;

    public PrefixedAlphanumericGenerator(String prefix, boolean wrap) {
        super(wrap, 15 - (prefix == null ? 0 : prefix.length()));
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        if (15 <= prefix.length()) {
            throw new IllegalArgumentException("size less prefix length must be at least one");
        }
        this.prefix = prefix;
    }

    public PrefixedAlphanumericGenerator(String prefix, boolean wrap, int size) {
        super(wrap, size - (prefix == null ? 0 : prefix.length()));
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        if (size <= prefix.length()) {
            throw new IllegalArgumentException("size less prefix length must be at least one");
        }
        this.prefix = prefix;
    }

    public PrefixedAlphanumericGenerator(String prefix, boolean wrap, String initialValue) {
        super(wrap, prefix == null ? initialValue : initialValue.substring(prefix.length()));
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        if (initialValue.length() <= prefix.length()) {
            throw new IllegalArgumentException("size less prefix length must be at least one");
        }
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public long maxLength() {
        return super.maxLength() + (long)this.prefix.length();
    }

    @Override
    public long minLength() {
        return super.minLength() + (long)this.prefix.length();
    }

    @Override
    public int getSize() {
        return super.getSize() + this.prefix.length();
    }

    @Override
    public String nextStringIdentifier() throws MaxReachedException {
        StringBuffer sb = new StringBuffer(this.prefix);
        sb.append(super.nextStringIdentifier());
        return sb.toString();
    }
}

