/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.id.apache.serial;

import it.link.pdd.tools.migrazione_govway.utils.id.apache.AbstractStringIdentifierGenerator;
import it.link.pdd.tools.migrazione_govway.utils.id.apache.serial.MaxReachedException;
import java.io.Serializable;

public class NumericGenerator
extends AbstractStringIdentifierGenerator
implements Serializable {
    private static final long serialVersionUID = 20060121L;
    private boolean wrapping;
    private long count = 0L;

    public NumericGenerator(boolean wrap, long initialValue) {
        this.wrapping = wrap;
        this.count = initialValue;
    }

    @Override
    public long maxLength() {
        return AbstractStringIdentifierGenerator.MAX_LONG_NUMERIC_VALUE_LENGTH;
    }

    @Override
    public long minLength() {
        return 1L;
    }

    public boolean isWrap() {
        return this.wrapping;
    }

    public void setWrap(boolean wrap) {
        this.wrapping = wrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String nextStringIdentifier() throws MaxReachedException {
        long value = 0L;
        if (this.wrapping) {
            NumericGenerator numericGenerator = this;
            synchronized (numericGenerator) {
                value = this.count++;
            }
        }
        NumericGenerator numericGenerator = this;
        synchronized (numericGenerator) {
            if (this.count == Long.MAX_VALUE) {
                throw new MaxReachedException("The maximum number of identifiers has been reached");
            }
            value = this.count++;
        }
        return Long.toString(value);
    }
}

