/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.id;

import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.id.IUniqueIdentifier;
import it.link.pdd.tools.migrazione_govway.utils.id.IUniqueIdentifierGenerator;
import it.link.pdd.tools.migrazione_govway.utils.id.UniqueIdentifierException;
import it.link.pdd.tools.migrazione_govway.utils.resources.Loader;
import org.slf4j.Logger;

public class UniqueIdentifierManager {
    private static IUniqueIdentifierGenerator uniqueIdentifierGenerator;
    private static boolean generazioneUIDDisabilitata;

    public static boolean isGenerazioneUIDDisabilitata() {
        return generazioneUIDDisabilitata;
    }

    public static void disabilitaGenerazioneUID() {
        generazioneUIDDisabilitata = true;
    }

    public static synchronized void inizializzaUniqueIdentifierManager(String className, Object ... o) throws UniqueIdentifierException {
        if (uniqueIdentifierGenerator == null) {
            try {
                uniqueIdentifierGenerator = (IUniqueIdentifierGenerator)Loader.getInstance().newInstance(className);
                uniqueIdentifierGenerator.init(o);
            }
            catch (Exception e) {
                throw new UniqueIdentifierException("Riscontrato errore durante il caricamento del data manager specificato [class:" + className + "]: " + e.getMessage(), e);
            }
        }
    }

    public static IUniqueIdentifier newUniqueIdentifier() throws UniqueIdentifierException {
        if (generazioneUIDDisabilitata) {
            return null;
        }
        try {
            if (uniqueIdentifierGenerator == null) {
                Logger log = LoggerWrapperFactory.getLogger(UniqueIdentifierManager.class);
                log.error("UniqueIdentifierManager non inizializzato");
                UniqueIdentifierManager.inizializzaUniqueIdentifierManager("org.openspcoop.utils.id.ClusterIdentifier", new Object[0]);
            }
            return uniqueIdentifierGenerator.newID();
        }
        catch (Exception e) {
            throw new UniqueIdentifierException("UniqueIdentifierManager.newID() non riuscita", e);
        }
    }

    public static IUniqueIdentifier convertFromString(String value) throws UniqueIdentifierException {
        if (generazioneUIDDisabilitata) {
            return null;
        }
        try {
            if (uniqueIdentifierGenerator == null) {
                Logger log = LoggerWrapperFactory.getLogger(UniqueIdentifierManager.class);
                log.error("UniqueIdentifierManager non inizializzato");
                UniqueIdentifierManager.inizializzaUniqueIdentifierManager("org.openspcoop.utils.id.ClusterIdentifier", new Object[0]);
            }
            return uniqueIdentifierGenerator.convertFromString(value);
        }
        catch (Exception e) {
            throw new UniqueIdentifierException("UniqueIdentifierManager.convertFromString() non riuscita", e);
        }
    }

    static {
        generazioneUIDDisabilitata = false;
    }
}

